<?php $__env->startSection('title', 'Our Products | Extrutech Hardware'); ?>
<?php
    $seo = [
        'title' => 'Extrutech Hardware',
        'description' => 'Extrutech Hardware.',
        'keywords' => 'products, extrutech, hardware',
        'image' => asset('assets/user/img/extrutech.png'),
        'author' => 'Extrutech Hardware',
        'robots' => 'INDEX,FOLLOW',
        'canonical' => url('/')
    ];
?>

<?php $__env->startSection('meta'); ?>
<meta property="og:type" content="website">
<meta property="og:title" content="<?php echo e($seo['title']); ?>">
<meta property="og:description" content="<?php echo e($seo['description']); ?>">
<meta property="og:image" content="<?php echo e($seo['image']); ?>">
<meta property="og:url" content="<?php echo e($seo['canonical']); ?>">
<meta property="og:site_name" content="Extrutech Hardware">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?php echo e($seo['title']); ?>">
<meta name="twitter:description" content="<?php echo e($seo['description']); ?>">
<meta name="twitter:image" content="<?php echo e($seo['image']); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('schema'); ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "CollectionPage",
  "name": "Extrutech Hardware Products",
  "description": "Explore aluminium architectural hardware & profiles.",
  "url": "<?php echo e(url()->current()); ?>",
  "image": "<?php echo e(asset('img/seo/home-banner.jpg')); ?>"
}
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="breadcumb-area" itemscope itemtype="https://schema.org/BreadcrumbList">
        <div class="breadcumb-wrapper" data-bg-src="<?php echo e(asset('assets/user/img/bg/breadcumb-bg.jpg')); ?>">
            <div class="container">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title text-anime" itemprop="name"><?php echo e($category->name); ?></h1>
                    <ul class="breadcumb-menu">
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <a href="<?php echo e(url('/')); ?>" itemprop="item"><span itemprop="name">Home</span></a>
                            <meta itemprop="position" content="1" />
                        </li>
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <span itemprop="name">Products</span>
                            <meta itemprop="position" content="2" />
                        </li>
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <span itemprop="name"><?php echo e($category->name); ?></span>
                            <meta itemprop="position" content="3" />
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <section class="space-top space-extra-bottom">
        <div class="container">
            <div class="row gy-4">
                <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-xl-4 col-md-6">
                        <div class="th-product product-grid">
                            <div class="product-img">
                                <a href="<?php echo e(route('productdetails', [$category->slug, $product->slug])); ?>">
                                    <img src="<?php echo e($product->image ? asset($product->image) : 'https://via.placeholder.com/400x400.png?text=No+Image'); ?>"
                                        alt="<?php echo e($product->name); ?>" title="<?php echo e($product->name); ?>" class="img-fluid">
                                </a>
                            </div>
                            <div class="product-content">
                                <h2 class="product-title">
                                    <a href="<?php echo e(route('productdetails', [$category->slug, $product->slug])); ?>">
                                        <?php echo e($product->name); ?>

                                    </a>
                                </h2>
                                <p class="box-text">
                                    <?php echo Str::limit(strip_tags($product->description), 400); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-12 text-center py-5">
                        <p class="text-muted fs-18">No products available at the moment.</p>
                    </div>
                <?php endif; ?>

            </div>

            <?php if($products->hasPages()): ?>
                <div class="th-pagination text-center mt-60">
                    <?php echo e($products->links('pagination::bootstrap-5')); ?>

                </div>
            <?php endif; ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layout.sub-app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/extrutechhardwar/public_html/development.extrutechhardware.com/resources/views/user/products.blade.php ENDPATH**/ ?>