<?php $sitesetting = App\Models\Sitesetting::first();  ?>
<?php $__env->startSection('meta'); ?>
  <meta name="description" content="<?php echo e($sitesetting->meta_desc); ?>" />
  <meta name="keywords" content="<?php echo e($sitesetting->meta_keyword); ?>" />
  <meta name="author" content="<?php echo e($sitesetting->comp_name); ?>" />
  <meta name="robots" content="index, follow" />
  <link rel="canonical" href="<?php echo e(url('/')); ?>" />
  <meta property="og:title" content="<?php echo e($sitesetting->comp_name); ?>" />
  <meta property="og:description" content="<?php echo e($sitesetting->meta_desc); ?>" />

  <meta property="og:url" content="<?php echo e(url('/')); ?>" />
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="630">
  <meta property="og:type" content="website" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="<?php echo e($sitesetting->comp_name); ?>" />
  <meta name="twitter:description" content="<?php echo e($sitesetting->meta_desc); ?>" />

  <meta name="twitter:image:width" content="1200">
  <meta name="twitter:image:height" content="675">
<?php $__env->stopSection(); ?>
<script type="application/ld+json">
  {
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "<?php echo e($sitesetting->comp_name ?? 'Pandit Chirag Guruji'); ?>",
    "url": "<?php echo e(url('/')); ?>",
    "logo": "<?php echo e(asset($sitesetting->image ?? '')); ?>",
    "description": "Guiding lives through the ancient wisdom of the stars, offering trusted astrological insights, remedies, and predictions to help you make informed decisions and embrace your destiny with confidence.",
    "contactPoint": [
      {
        "@type": "ContactPoint",
        "telephone": <?php echo e($sitesetting->comp_phone); ?>,
        "areaServed": "IN",
        "availableLanguage": ["Hindi", "English","Gujarati"]
      }
    ],
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "<?php echo e(strip_tags($sitesetting->comp_address ?? '')); ?>",
      "addressLocality": "Rajkot",
      "addressRegion": "Gujarat",
      "postalCode": "360021",
      "addressCountry": "IN"
    },
    "breadcrumb": {
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "<?php echo e(url('/')); ?>"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Services",
          "item": "<?php echo e(url('/')); ?>/services"
        }
      ]
    }
  }
</script>

<style>
.manual-style p {
    margin: 0 0 20px;
    color: #ec6f31;
    font-weight: 700;
    font-size: 28px;
    line-height: 1.4;
}

</style>


<?php $__env->startSection('pagetitle'); ?>
  <title><?php echo e($sitesetting->comp_name); ?> | Forecast Details</title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="sigma_subheader dark-overlay dark-overlay-2" style="background-image: url(<?php echo e(asset('assets/user/images/subheader.jpg')); ?>)">

    <div class="container">
      <div class="sigma_subheader-inner">
        <div class="sigma_subheader-text">
          <h1>Forecast Details</h1>
        </div>
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a class="btn-link" href="<?php echo e(url('/')); ?>">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Forecast Details</li>
          </ol>
        </nav>
      </div>
    </div>

  </div>

  <section class="section">
    <div class="container">
        <div class="text-center">
            <h4 class="manual-style"><?php echo $forecast->title; ?></h4>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="as_about_detail">
                    <h1 class="as_heading">Description</h1>
                    <div class="as_paragraph_wrapper">
                        <?php echo $forecast->description; ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layout.subapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/panditchiragguru/public_html/resources/views/user/forecast-details.blade.php ENDPATH**/ ?>