<!doctype html>
<html lang="en">
<?php
$sitesetting = App\Models\Sitesetting::first();
?>

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <title><?php echo e($seo['title'] ?? $sitesetting->meta_tag ?? $sitesetting->comp_name ?? 'Extrutech Hardware'); ?></title>

    <meta name="author" content="<?php echo e($seo['author'] ?? $sitesetting->comp_name ?? 'Extrutech Hardware'); ?>">
    <meta name="description" content="<?php echo e($seo['description'] ?? $sitesetting->meta_desc ?? 'Extrutech Hardware'); ?>">
    <meta name="keywords" content="<?php echo e($seo['keywords'] ?? $sitesetting->meta_keyword ?? 'Extrutech Hardware'); ?>">
    <meta name="robots" content="<?php echo e($seo['robots'] ?? 'INDEX,FOLLOW'); ?>">
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">

    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset($sitesetting->fevicon ?? 'assets/user/img/favicons/favicon-96x96.png')); ?>">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset($sitesetting->fevicon ?? 'assets/user/img/favicons/favicon-96x96.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset($sitesetting->fevicon ?? 'assets/user/img/favicons/favicon-96x96.png')); ?>">
    <link rel="manifest" href="<?php echo e(asset('assets/user/img/favicons/manifest.json')); ?>">
    <meta name="theme-color" content="#ffffff">

    <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/fontawesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/magnific-popup.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/swiper-bundle.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/style.css')); ?>">

    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo $__env->yieldContent('meta'); ?>
    <?php echo $__env->yieldContent('schema'); ?>
</head>


<body id="show-grid">
    <?php
        $categories = App\Models\Category::where('status', 'Active')->orderBy('name')->get();
    ?>
    <div class="cursor"></div>
    <div class="cursor2"></div>

    <!-- Preloader -->
    <div class="loader-wrap">
        <svg viewBox="0 0 1000 1000" preserveAspectRatio="none">
            <path id="svg" d="M0,1005S175,995,500,995s500,5,500,5V0H0Z"></path>
        </svg>
        <div class="loader-wrap-heading">
            <div class="load-text">
                <span>L</span><span>o</span><span>a</span><span>d</span><span>i</span><span>n</span><span>g</span>
            </div>
        </div>
    </div>

    <!-- Mobile Menu Wrapper -->
    <div class="th-menu-wrapper">
        <div class="th-menu-area text-center">
            <button class="th-menu-toggle">
                <i class="fal fa-times"></i>
            </button>
            <div class="mobile-logo">
                <a href="<?php echo e(url('/')); ?>">
                    <img src="<?php echo e(asset('assets/user/img/extrutech.png')); ?>" alt="Faren">
                </a>
            </div>
            <div class="th-mobile-menu">
                <ul>
                    <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
                    <li><a href="<?php echo e(url('/about')); ?>">About</a></li>
                    <li><a href="<?php echo e(url('/services')); ?>">Services</a></li>
                    <li class="has-submenu">
                        <a href="javascript:void(0)" class="mobile-trigger">
                            Products <span class="arrow">+</span>
                        </a>
                        <ul class="submenu">
                            <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <li>
                                    <a href="<?php echo e(url('/products/' . $category->slug)); ?>"><?php echo e($category->name); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <li><a href="#">No categories found</a></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <li><a href="<?php echo e(url('/gallery')); ?>">Gallery</a></li>
                    <li><a href="<?php echo e(url('/blog')); ?>">Blog</a></li>
                    <li><a href="<?php echo e(url('/contact')); ?>">Contact</a></li>
                    <li><a href="<?php echo e(url('/brochure')); ?>">Brochure</a></li>
                </ul>
            </div>
        </div>
    </div>
    <header class="th-header header-layout2">
        <div class="sticky-wrapper">
            <div class="container th-container">
                <div class="menu-area">
                    <div class="row align-items-center justify-content-between">
                        <div class="col-auto">
                            <a href="<?php echo e(url('/')); ?>" title="Extrutech Hardware – Premium Aluminium Architectural Hardware & Profiles">
                                <img src="<?php echo e(asset('assets/user/img/logo-2.png')); ?>"
                                    alt="Extrutech Hardware Logo – Aluminium Architectural Hardware Manufacturer"
                                    title="Extrutech Hardware – Trusted Aluminium Hardware & Profiles Manufacturer">
                            </a>
                        </div>
                        <div class="col-auto me-auto">
                            <nav class="main-menu d-none d-lg-inline-block">
                                <ul>
                                    <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
                                    <li><a href="<?php echo e(url('/about')); ?>">About</a></li>
                                    <li><a href="<?php echo e(url('/services')); ?>">Services</a></li>
                                    <li class="has-submenu">
                                        <a href="javascript:void(0)">Products</a>
                                        <ul class="submenu">
                                            <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <li>
                                                    <a href="<?php echo e(url('/products/' . $category->slug)); ?>"><?php echo e($category->name); ?></a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <li><a href="#">No categories found</a></li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <li><a href="<?php echo e(url('/gallery')); ?>">Gallery</a></li>
                                    <li><a href="<?php echo e(url('/blog')); ?>">Blog</a></li>
                                    <li><a href="<?php echo e(url('/brochure')); ?>">Brochure</a></li>
                                </ul>
                            </nav>
                        </div>
                        <div class="col-auto">
                            <div class="header-button d-none d-xl-flex">
                                <a href="<?php echo e(url('/contact')); ?>" class="th-btn style2">Get Free Consultant</a>
                            </div>
                            <div class="header-button">
                                <button type="button" class="th-menu-toggle d-inline-block d-lg-none">
                                    <i class="far fa-bars"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('user.layout.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script src="<?php echo e(asset('assets/user/js/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/jquery.counterup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/circle-progress.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/imagesloaded.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/isotope.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/nice-select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/wow.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/threesixty.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/panolens.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/gsap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/ScrollTrigger.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/SplitText.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/SplitType.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/lenis.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/CustomEase.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/main.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.16.105/pdf.min.js"></script>
    <script>
        pdfjsLib.GlobalWorkerOptions.workerSrc =
        "https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.16.105/pdf.worker.min.js";
    </script>

    <script type="importmap">
        {
        "imports": {
            "three": "https://unpkg.com/three@0.160.0/build/three.module.js"
        }
        }
    </script>
    <?php echo $__env->yieldContent('js'); ?>

</body>
</html>
<?php /**PATH /home/extrutechhardwar/public_html/development.extrutechhardware.com/resources/views/user/layout/sub-app.blade.php ENDPATH**/ ?>