<?php $__env->startSection('title', $product->name . ' | Extrutech Hardware'); ?>

<?php
    $seo = [
        'title' => $product->name . ' | Extrutech Hardware',
        'description' => Str::limit(strip_tags($product->description), 160),
        'keywords' => $product->meta_keywords ?? 'hardware, extrutech',
        'image' => $product->image ? asset($product->image) : asset('assets/user/img/extrutech.png'),
        'author' => 'Extrutech Hardware',
        'robots' => 'INDEX,FOLLOW',
        'canonical' => url()->current()
    ];
?>

<?php $__env->startSection('meta'); ?>

<!-- Open Graph / Facebook -->
<meta property="og:type" content="product">
<meta property="og:title" content="<?php echo e($seo['title']); ?>">
<meta property="og:description" content="<?php echo e($seo['description']); ?>">
<meta property="og:image" content="<?php echo e($seo['image']); ?>">
<meta property="og:url" content="<?php echo e($seo['canonical']); ?>">
<meta property="og:site_name" content="Extrutech Hardware">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?php echo e($seo['title']); ?>">
<meta name="twitter:description" content="<?php echo e($seo['description']); ?>">
<meta name="twitter:image" content="<?php echo e($seo['image']); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('schema'); ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Product",
  "name": "<?php echo e($product->name); ?>",
  "image": "<?php echo e($seo['image']); ?>",
  "description": "<?php echo e($seo['description']); ?>",
  "sku": "<?php echo e($product->sku ?? 'N/A'); ?>",
  "brand": {
    "@type": "Brand",
    "name": "<?php echo e($product->brand->name ?? 'Extrutech Hardware'); ?>"
  },
  "offers": {
    "@type": "Offer",
    "url": "<?php echo e($seo['canonical']); ?>",
    "priceCurrency": "INR",
    "price": "<?php echo e($product->rate ?? 0); ?>",
    "availability": "<?php echo e($product->status == 'Active' ? 'https://schema.org/InStock' : 'https://schema.org/OutOfStock'); ?>"
  }
}
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="breadcumb-area" itemscope itemtype="https://schema.org/BreadcrumbList">
    <div class="breadcumb-wrapper" data-bg-src="<?php echo e(asset('assets/user/img/bg/breadcumb-bg.jpg')); ?>">
        <div class="container">
            <div class="breadcumb-content">
                <h1 class="breadcumb-title text-anime" itemprop="name"><?php echo e($product->name); ?></h1>
                <ul class="breadcumb-menu">
                    <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                        <a href="<?php echo e(url('/')); ?>" itemprop="item"><span itemprop="name">Home</span></a>
                        <meta itemprop="position" content="1" />
                    </li>
                    <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                        <span itemprop="name"><a href="<?php echo e(url('/products/'.$category->slug)); ?>"><?php echo e($category->name); ?></a></span>
                        <meta itemprop="position" content="2" />
                    </li>
                    <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                        <span itemprop="name"><?php echo e($product->name); ?></span>
                        <meta itemprop="position" content="3" />
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<!-- Product Details -->
<section class="py-5">
    <div class="container">
        <div class="row g-4">
            <div class="col-lg-12 col-md-12 text-center">
                <img src="<?php echo e($product->image ? asset($product->image) : 'https://via.placeholder.com/600x600.png?text=No+Image'); ?>" 
                     alt="<?php echo e($product->name); ?>" title="<?php echo e($product->name); ?>" class="img-fluid rounded shadow-sm">
            </div>

            <div class="col-lg-12 col-md-12">
                <h2 class="product-title mb-3"><?php echo e($product->name); ?></h2>
                <p class="product-description mb-3"><?php echo $product->description; ?></p>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layout.sub-app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/extrutechhardwar/public_html/development.extrutechhardware.com/resources/views/user/productdetails.blade.php ENDPATH**/ ?>