<!doctype html>
<html lang="en">
<?php
$sitesetting = App\Models\Sitesetting::first();
?>

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <title><?php echo e($seo['title'] ?? $sitesetting->meta_tag ?? $sitesetting->comp_name ?? 'Extrutech Hardware'); ?></title>

    <meta name="author" content="<?php echo e($seo['author'] ?? $sitesetting->comp_name ?? 'Extrutech Hardware'); ?>">
    <meta name="description" content="<?php echo e($seo['description'] ?? $sitesetting->meta_desc ?? 'Extrutech Hardware'); ?>">
    <meta name="keywords" content="<?php echo e($seo['keywords'] ?? $sitesetting->meta_keyword ?? 'Extrutech Hardware'); ?>">
    <meta name="robots" content="<?php echo e($seo['robots'] ?? 'INDEX,FOLLOW'); ?>">
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">

    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset($sitesetting->fevicon ?? 'assets/user/img/favicons/favicon-96x96.png')); ?>">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset($sitesetting->fevicon ?? 'assets/user/img/favicons/favicon-96x96.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset($sitesetting->fevicon ?? 'assets/user/img/favicons/favicon-96x96.png')); ?>">
    <link rel="manifest" href="<?php echo e(asset('assets/user/img/favicons/manifest.json')); ?>">
    <meta name="theme-color" content="#ffffff">

    <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/fontawesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/magnific-popup.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/swiper-bundle.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/style.css')); ?>">

    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo $__env->yieldContent('meta'); ?>
    <?php echo $__env->yieldContent('schema'); ?>
</head>


<body id="show-grid">
    <?php echo $__env->make('user.layout.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('user.layout.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script src="<?php echo e(asset('assets/user/js/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/jquery.counterup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/circle-progress.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/imagesloaded.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/isotope.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/nice-select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/wow.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/threesixty.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/panolens.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/gsap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/ScrollTrigger.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/SplitText.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/SplitType.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/lenis.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/CustomEase.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/user/js/main.js')); ?>"></script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.16.105/pdf.min.js"></script>
    <script>
        pdfjsLib.GlobalWorkerOptions.workerSrc =
        "https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.16.105/pdf.worker.min.js";
    </script>

    <script type="importmap">
        {
        "imports": {
            "three": "https://unpkg.com/three@0.160.0/build/three.module.js"
        }
        }
    </script>
    <?php echo $__env->yieldContent('js'); ?>
</body>
</html>
<?php /**PATH /home/extrutechhardwar/public_html/development.extrutechhardware.com/resources/views/user/layout/app.blade.php ENDPATH**/ ?>