<?php
use App\Http\Controllers\AdminAuth\UserController;
use App\Http\Controllers\AdminAuth\SliderController;
use App\Http\Controllers\AdminAuth\AboutController;
use App\Http\Controllers\AdminAuth\BlogController;
use App\Http\Controllers\AdminAuth\BrochureController;
use App\Http\Controllers\AdminAuth\TeamController;
use App\Http\Controllers\AdminAuth\VendorController;
use App\Http\Controllers\AdminAuth\VendorpaymentController;
use App\Http\Controllers\AdminAuth\CareersController;
use App\Http\Controllers\AdminAuth\CategoryController;
use App\Http\Controllers\AdminAuth\ProductController;
use App\Http\Controllers\AdminAuth\PortfolioController;
use App\Http\Controllers\AdminAuth\ServiceController;
use App\Http\Controllers\AdminAuth\ClientGalleryController;
use App\Http\Controllers\AdminAuth\PaymentController;
use App\Http\Controllers\AdminAuth\EnquiriesController;

use App\Http\Controllers\AdminAuth\TestimonialController;
use App\Http\Controllers\AdminAuth\MediaController;

use App\Http\Controllers\AdminAuth\GalleryController;

use App\Http\Controllers\AdminAuth\LoginRegisterController as AdminloginController;

use App\Http\Controllers\AdminAuth\PropertyController;
use App\Http\Controllers\AdminAuth\EducationController;
use App\Http\Controllers\AdminAuth\AboutusController;
use App\Http\Controllers\AdminAuth\ForecastController;

use Illuminate\Support\Facades\Route;

/*   
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/clearcache', function() {
    $exitCode = Artisan::call('cache:clear');
    $exitCode = Artisan::call('optimize');
    $exitCode = Artisan::call('route:cache');
    $exitCode = Artisan::call('config:cache');
    $exitCode = Artisan::call('route:clear');
    $exitCode = Artisan::call('view:clear');
    return '<h1>Cache facade value cleared</h1>';
});

Route::controller(AdminloginController::class)->group(function() {
    Route::get('admin/register', 'register')->name('admin.register');
    Route::post('admin/store', 'store')->name('admin.store');
    Route::get('admin/login', 'login')->name('admin.login');
    Route::post('admin/authenticate', 'authenticate')->name('admin.authenticate');
    Route::any('admin/logout', 'logout')->name('admin.logout');
});
Route::prefix('admin')->group(function() {
    Route::group(['middleware' => ['is_admin']], function() {
        Route::get('testQuery', [App\Http\Controllers\AdminAuth\HomeController::class,'testQuery']);
        Route::get('dashboard', [App\Http\Controllers\AdminAuth\HomeController::class, 'dashboard'])->name('admin.dashboard');
        Route::post('calculatenumbertotal', [App\Http\Controllers\AdminAuth\HomeController::class, 'calculatenumbertotal'])->name('admin.calculatenumbertotal');
        Route::post('convertwordtonumber', [App\Http\Controllers\AdminAuth\HomeController::class, 'convertwordtonumber'])->name('admin.convertwordtonumber');
        
        Route::get('profile/edit', [App\Http\Controllers\AdminAuth\HomeController::class, 'profile_edit'])->name('admin.profile_edit');
        Route::post('profile/update', [App\Http\Controllers\AdminAuth\HomeController::class, 'profile_update'])->name('admin.profile_update');

        Route::resource('user', UserController::class);
        Route::get('sitesetting',[App\Http\Controllers\AdminAuth\SitesettingController::class, 'sitesetting'])->name('admin.sitesetting');
        Route::post('update',[App\Http\Controllers\AdminAuth\SitesettingController::class, 'updatesitesetting'])->name('admin.sitesetting.update');
        Route::get('getnumber_search',[App\Http\Controllers\AdminAuth\SitesettingController::class, 'getnumber_search'])->name('admin.getnumber_search');
        Route::get('policy',[App\Http\Controllers\AdminAuth\PolicyController::class, 'policy'])->name('admin.policy');
        Route::post('update/{id}',[App\Http\Controllers\AdminAuth\PolicyController::class, 'updatepolicy'])->name('admin.policy.update');
        Route::resource('category', CategoryController::class);
        Route::resource('product', ProductController::class);
        Route::resource('team', TeamController::class);
        Route::resource('portfolio', PortfolioController::class);
        Route::resource('service', ServiceController::class);
        Route::post('categorydelete/{id}',[CategoryController::class, 'categorydelete']);
        Route::get('getCategories',[CategoryController::class, 'getCategories']);
        Route::resource('slider', SliderController::class);
        Route::post('sliderdelete/{id}',[SliderController::class, 'sliderdelete']);

        // Route::get('education', [EducationController::class, 'index'])->name('admin.education.index');
        // Route::get('education/{id}/edit', [EducationController::class, 'edit'])->name('admin.education.edit');
        // Route::post('education/{id}', [EducationController::class, 'update'])->name('admin.education.update');
        Route::resource('education', EducationController::class);
        Route::resource('aboutus', AboutusController::class);


        Route::post('category-image-delete',[CategoryController::class, 'categoryImageDelete']);

        Route::get('goal/create',[ AboutController::class ,'create']);
        Route::post('goal/update',[ AboutController::class ,'update'])->name('admin.about.update');
        
        Route::resource('careers', CareersController::class);
        Route::post('careersdelete/{id}',[CareersController::class, 'careersdelete']);

        Route::resource('blog', BlogController::class);
        Route::post('blogdelete/{id}',[BlogController::class, 'blogdelete']);

        Route::resource('brochure', BrochureController::class);
        Route::post('brochuredelete/{id}',[BrochureController::class, 'brochuredelete']);

        Route::get('inquiry',[App\Http\Controllers\AdminAuth\InquiryController::class, 'index']);
        Route::resource('vendor', VendorController::class);
        Route::post('vendordelete/{id}',[VendorController::class, 'vendordelete']);
        Route::get('deleteVendorProduct',[VendorController::class, 'deleteVendorProduct']);
        Route::post('deleteallvendor',[VendorController::class, 'deleteallvendor']);
        Route::resource('vendorpayment', VendorpaymentController::class);

        Route::get('forecast', [ForecastController::class, 'index'])->name('forecast.index');
        Route::get('forecast/create', [ForecastController::class, 'create'])->name('forecast.create');
        Route::get('forecast/{id}/edit', [ForecastController::class, 'edit'])->name('forecast.edit');
    
        Route::post('forecast/store', [ForecastController::class, 'store'])->name('forecast.store');
        Route::post('forecast/{id}/update', [ForecastController::class, 'update'])->name('forecast.update');


        Route::post('vendorpaymentdelete/{id}',[VendorpaymentController::class, 'vendorpaymentdelete']);
        Route::resource('payment', PaymentController::class);
        

        Route::resource('enquiries', EnquiriesController::class);
        Route::resource('client', ClientController::class);
        Route::post('addcomment', [EnquiriesController::class, 'addcomment']);
      
        Route::resource('property', PropertyController::class);

        Route::resource('clientgallery', ClientGalleryController::class);
        Route::resource('testimonial', TestimonialController::class);
        Route::resource('media', MediaController::class);
    }); 
});

  