@extends('user.layout.sub-app')
@section('title', $service->meta_title ?? $service->title)

@php
    $seo = [
        'title' => $service->meta_title ?? $service->title . ' | Extrutech Hardware',
        'description' => $service->meta_description ?? Str::limit(strip_tags($service->short_description), 160),
        'keywords' => $service->meta_keywords ?? 'aluminium hardware, glass hardware, ' . $service->title,
        'image' => asset('assets/user/img/extrutech.png'),
        'author' => 'Extrutech Hardware',
        'robots' => 'INDEX,FOLLOW',
        'canonical' => url('/')
    ];
@endphp

@section('meta')
<meta property="og:type" content="website">
<meta property="og:title" content="{{ $seo['title'] }}">
<meta property="og:description" content="{{ $seo['description'] }}">
<meta property="og:image" content="{{ $seo['image'] }}">
<meta property="og:url" content="{{ $seo['canonical'] }}">
<meta property="og:site_name" content="Extrutech Hardware">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="{{ $seo['title'] }}">
<meta name="twitter:description" content="{{ $seo['description'] }}">
<meta name="twitter:image" content="{{ $seo['image'] }}">
@endsection

@section('schema')
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Service",
  "name": "{{ $service->name }}",
  "description": "{{ strip_tags(Str::limit($service->description, 160)) }}",
  "image": "{{ asset($service->image) }}",
  "provider": {
    "@type": "Organization",
    "name": "Extrutech Hardware",
    "url": "{{ url('/') }}"
  },
  "url": "{{ url()->current() }}"
}
</script>
@endsection


@section('content')
    <div class="breadcumb-area" itemscope itemtype="https://schema.org/BreadcrumbList">
        <div class="breadcumb-wrapper" data-bg-src="{{ asset('assets/user/img/bg/breadcumb-bg.jpg') }}">
            <div class="container">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title text-anime" itemprop="name">{{ $service->name ?? 'Service Detail' }}</h1>
                    <ul class="breadcumb-menu">
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <a href="{{ url('/') }}" itemprop="item"><span itemprop="name">Home</span></a>
                            <meta itemprop="position" content="1" />
                        </li>
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <span itemprop="name">Service Detail</span>
                            <meta itemprop="position" content="2" />
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <section class="space overflow-hidden">
        <div class="container">

            <div class="page-img space-bottom">
                <img src="{{ asset($service->image) }}"
                    alt="{{ $service->name }}"
                    title="{{ $service->name }}">
            </div>

            <div class="row gy-4">
                <div class="col-xl-12">
                    <div class="page-content">
                        <h1 class="mb-3">{{ $service->name }}</h1>
                        <div class="fs-18 mb-50">{!! $service->description !!}</div>
                    </div>
                </div>
            </div>

        </div>
    </section>

@endsection