@extends('user.layout.sub-app')

@section('title', $product->name . ' | Extrutech Hardware')

@php
    $seo = [
        'title' => $product->name . ' | Extrutech Hardware',
        'description' => Str::limit(strip_tags($product->description), 160),
        'keywords' => $product->meta_keywords ?? 'hardware, extrutech',
        'image' => $product->image ? asset($product->image) : asset('assets/user/img/extrutech.png'),
        'author' => 'Extrutech Hardware',
        'robots' => 'INDEX,FOLLOW',
        'canonical' => url()->current()
    ];
@endphp

@section('meta')

<!-- Open Graph / Facebook -->
<meta property="og:type" content="product">
<meta property="og:title" content="{{ $seo['title'] }}">
<meta property="og:description" content="{{ $seo['description'] }}">
<meta property="og:image" content="{{ $seo['image'] }}">
<meta property="og:url" content="{{ $seo['canonical'] }}">
<meta property="og:site_name" content="Extrutech Hardware">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="{{ $seo['title'] }}">
<meta name="twitter:description" content="{{ $seo['description'] }}">
<meta name="twitter:image" content="{{ $seo['image'] }}">
@endsection

@section('schema')
<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Product",
  "name": "{{ $product->name }}",
  "image": "{{ $seo['image'] }}",
  "description": "{{ $seo['description'] }}",
  "sku": "{{ $product->sku ?? 'N/A' }}",
  "brand": {
    "@type": "Brand",
    "name": "{{ $product->brand->name ?? 'Extrutech Hardware' }}"
  },
  "offers": {
    "@type": "Offer",
    "url": "{{ $seo['canonical'] }}",
    "priceCurrency": "INR",
    "price": "{{ $product->rate ?? 0 }}",
    "availability": "{{ $product->status == 'Active' ? 'https://schema.org/InStock' : 'https://schema.org/OutOfStock' }}"
  }
}
</script>
@endsection

@section('content')
<div class="breadcumb-area" itemscope itemtype="https://schema.org/BreadcrumbList">
    <div class="breadcumb-wrapper" data-bg-src="{{ asset('assets/user/img/bg/breadcumb-bg.jpg') }}">
        <div class="container">
            <div class="breadcumb-content">
                <h1 class="breadcumb-title text-anime" itemprop="name">{{ $product->name }}</h1>
                <ul class="breadcumb-menu">
                    <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                        <a href="{{ url('/') }}" itemprop="item"><span itemprop="name">Home</span></a>
                        <meta itemprop="position" content="1" />
                    </li>
                    <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                        <span itemprop="name"><a href="{{ url('/products/'.$category->slug) }}">{{ $category->name }}</a></span>
                        <meta itemprop="position" content="2" />
                    </li>
                    <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                        <span itemprop="name">{{ $product->name }}</span>
                        <meta itemprop="position" content="3" />
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<!-- Product Details -->
<section class="py-5">
    <div class="container">
        <div class="row g-4">
            <div class="col-lg-12 col-md-12 text-center">
                <img src="{{ $product->image ? asset($product->image) : 'https://via.placeholder.com/600x600.png?text=No+Image' }}" 
                     alt="{{ $product->name }}" title="{{ $product->name }}" class="img-fluid rounded shadow-sm">
            </div>

            <div class="col-lg-12 col-md-12">
                <h2 class="product-title mb-3">{{ $product->name }}</h2>
                <p class="product-description mb-3">{!! $product->description !!}</p>
            </div>
        </div>
    </div>
</section>
@endsection
