<!doctype html>
<html lang="en">
@php
$sitesetting = App\Models\Sitesetting::first();
@endphp

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <title>{{ $seo['title'] ?? $sitesetting->meta_tag ?? $sitesetting->comp_name ?? 'Extrutech Hardware' }}</title>

    <meta name="author" content="{{ $seo['author'] ?? $sitesetting->comp_name ?? 'Extrutech Hardware' }}">
    <meta name="description" content="{{ $seo['description'] ?? $sitesetting->meta_desc ?? 'Extrutech Hardware' }}">
    <meta name="keywords" content="{{ $seo['keywords'] ?? $sitesetting->meta_keyword ?? 'Extrutech Hardware' }}">
    <meta name="robots" content="{{ $seo['robots'] ?? 'INDEX,FOLLOW' }}">
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">

    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset($sitesetting->fevicon ?? 'assets/user/img/favicons/favicon-96x96.png') }}">
    <link rel="icon" type="image/png" sizes="96x96" href="{{ asset($sitesetting->fevicon ?? 'assets/user/img/favicons/favicon-96x96.png') }}">
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset($sitesetting->fevicon ?? 'assets/user/img/favicons/favicon-96x96.png') }}">
    <link rel="manifest" href="{{ asset('assets/user/img/favicons/manifest.json') }}">
    <meta name="theme-color" content="#ffffff">

    <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="{{ asset('assets/user/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/user/css/fontawesome.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/user/css/magnific-popup.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/user/css/swiper-bundle.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/user/css/style.css') }}">

    @stack('styles')
    @yield('meta')
    @yield('schema')
</head>


<body id="show-grid">
    @include('user.layout.header')
    @yield('content')
    @include('user.layout.footer')

    <script src="{{ asset('assets/user/js/jquery-3.7.1.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/swiper-bundle.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/jquery.magnific-popup.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/jquery.counterup.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/circle-progress.js') }}"></script>
    <script src="{{ asset('assets/user/js/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/imagesloaded.pkgd.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/isotope.pkgd.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/nice-select.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/wow.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/threesixty.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/panolens.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/gsap.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/ScrollTrigger.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/SplitText.js') }}"></script>
    <script src="{{ asset('assets/user/js/SplitType.js') }}"></script>
    <script src="{{ asset('assets/user/js/lenis.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/CustomEase.min.js') }}"></script>
    <script src="{{ asset('assets/user/js/main.js') }}"></script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.16.105/pdf.min.js"></script>
    <script>
        pdfjsLib.GlobalWorkerOptions.workerSrc =
        "https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.16.105/pdf.worker.min.js";
    </script>

    <script type="importmap">
        {
        "imports": {
            "three": "https://unpkg.com/three@0.160.0/build/three.module.js"
        }
        }
    </script>
    @yield('js')
</body>
</html>
