@php
$seo = [
    'title' => 'Home | Extrutech Hardware',
    'description' => 'Extrutech Hardware',
    'keywords' => 'aluminium hardware, extrutech, glass hardware, architectural hardware',
    'image' => asset('assets/user/img/extrutech.png'),
    'author' => 'Extrutech Hardware',
    'robots' => 'INDEX,FOLLOW',
    'canonical' => url('/')
];
@endphp

@extends('user.layout.app')
@section('title', $seo['title'])

@section('meta')
<meta property="og:type" content="website">
<meta property="og:title" content="{{ $seo['title'] }}">
<meta property="og:description" content="{{ $seo['description'] }}">
<meta property="og:image" content="{{ $seo['image'] }}">
<meta property="og:url" content="{{ $seo['canonical'] }}">
<meta property="og:site_name" content="Extrutech Hardware">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="{{ $seo['title'] }}">
<meta name="twitter:description" content="{{ $seo['description'] }}">
<meta name="twitter:image" content="{{ $seo['image'] }}">

<link rel="icon" href="{{ asset('assets/user/img/extrutech.png') }}" type="image/png">
@endsection


@section('schema')
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "Extrutech Hardware",
  "url": "{{ url('/') }}",
  "logo": "{{ asset('assets/user/img/seo/home-banner.jpg') }}",
  "sameAs": [
    "https://www.facebook.com/",
    "https://www.twitter.com/",
    "https://www.instagram.com/",
    "https://www.linkedin.com/"
  ]
}
</script>

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebSite",
  "url": "{{ url('/') }}",
  "name": "Extrutech Hardware",
  "potentialAction": {
    "@type": "SearchAction",
    "target": "{{ url('/') }}/search?query={search_term_string}",
    "query-input": "required name=search_term_string"
  }
}
</script>

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "{{ url('/') }}"
    }
  ]
}
</script>
@endsection


@section('content')
<div class="th-hero-wrapper hero-7 position-relative">
    <div class="swiper showcase-slider-active">
        <div class="swiper-wrapper">
            @foreach ($sliders as $slider)
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <div class="th-hero-bg showcase-slider-bg" data-bg-src="{{ asset($slider->image) }}" data-swiper-parallax="1152" alt="{{ $slider->title }}"></div>
                        <div class="container">
                            <div class="row align-items-end">
                                <div class="col-xl-7">
                                    <div class="hero-style7">
                                        {!! formatSliderTitle($slider->title, 'hero-title') !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        <div class="button-wrap">
            <div class="swiper-button-next" tabindex="0" role="button" aria-label="Next slide">
                <div><img src="{{ asset('assets/user/img/icon/hero-left-arrow.svg') }}" alt="Next" loading="lazy"></div>
            </div>
            <div class="swiper-button-prev" tabindex="0" role="button" aria-label="Previous slide">
                <div><img src="{{ asset('assets/user/img/icon/hero-right-arrow.svg') }}" alt="Previous" loading="lazy"></div>
            </div>
        </div>
    </div>

    <!-- <div class="hero-social">
        <a href="https://www.facebook.com/" target="_blank" rel="noopener" aria-label="Facebook">Facebook</a>
        <a href="https://www.twitter.com/" target="_blank" rel="noopener" aria-label="Twitter">Twitter</a>
        <a href="https://www.instagram.com/" target="_blank" rel="noopener" aria-label="Instagram">Instagram</a>
        <a href="https://www.linkedin.com/" target="_blank" rel="noopener" aria-label="Linkedin">Linkedin</a>
    </div> -->

    <div class="scroll-down">
        <a href="#about-sec" class="hero-scroll-wrap" aria-label="Scroll Down">Scroll Down</a>
    </div>
</div>

<!-- About Section -->
<div class="overflow-hidden space" id="about-sec">
    <div class="container">
        <div class="row gy-4 align-items-end justify-content-end">
            <div class="col-xl-5">
                <div class="title-area">
                    <span class="sub-title text-anime">ABOUT THE FIRM</span>
                </div>
                <div class="img-box10">
                    <div class="about-wrapp2">
                        <div class="discount-wrapp">
                            <a href="https://www.youtube.com/watch?v=_sI_Ps7JSEk" class="play-btn popup-video" aria-label="Play Video">
                                <i class="fa-sharp fa-solid fa-play"></i>
                            </a>
                            <div class="discount-tag">
                                <span class="discount-anime">
                                    {{ $aboutus->title ?? 'Extrutech Hardware' }} ** Spiritual Guidance **
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="">
                        <div class="th-clip-anim">
                            <img class="th-anim-img gallery_img" data-animate="true"src="{{ asset($aboutus->image1) }}" alt="{{ $aboutus->title ?? 'About' }}" loading="lazy">
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-7">
                <div class="title-area mb-0 pe-xxl-5 me-xxl-5">
                    <h2 class="sec-title style5 split-text me-xxl-2">
                        {{ $aboutus->title ?? 'About Our Spiritual Journey & Commitment' }}
                    </h2>
                    <div class="me-xxl-5 pe-xxl-5">
                        <p class="fs-18 mb-60 wow fadeInUp me-xxl-5 pe-xxl-5" data-wow-delay=".2s">
                            {!! Str::limit(strip_tags($aboutus->description), 400, '...') !!}
                        </p>
                    </div>
                    <h4 class="box-title3">Spiritual Legacy</h4>
                </div>

                <div class="img-box9">
                    <div class="img-box9_wrapp">
                        <div class="counter-box_wrapp">
                            <div class="counter-box wow fadeInUp" data-wow-delay=".2s">
                                <h3 class="box-number">
                                    <span class="counter-number">25</span>+
                                </h3>
                                <p class="box-text">Years of Spiritual Service</p>
                            </div>
                            <div class="counter-box wow fadeInUp" data-wow-delay=".4s">
                                <h3 class="box-number">
                                    <span class="counter-number">5000</span>+
                                </h3>
                                <p class="box-text">Puja & Yagna Performed</p>
                            </div>
                        </div>
                        <div class="">
                            <div class="th-clip-anim">
                                <img class="th-anim-img gallery_img" data-animate="true" src="{{ asset($aboutus->image2) }}" alt="{{ $aboutus->title ?? 'Guruji' }}" loading="lazy">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Services Section -->
<section class="position-relative overflow-hidden space-bottom overflow-hidden" id="service-sec">
    <div class="container">
        <div class="row justify-content-center align-items-center">
            <div class="col-xl-6">
                <div class="title-area text-center">
                    <span class="sub-title style2 text-anime">Our Services</span>
                    <h2 class="sec-title style5 split-text">
                        Spiritual & Vedic Services for Peace, Prosperity & Harmony
                    </h2>
                </div>
            </div>
        </div>

        <div class="service-wrapper">
            <div class="row gy-4 gy-xl-0 gx-xl-0">
                @forelse($services as $service)
                    <div class="col-lg-6">
                        <div class="service-block2 style1 wow fadeInUp" data-wow-delay=".{{ $loop->iteration }}s">
                            <div class="box-img global-img order-xl-1">
                                <img src="{{ asset($service->image) }}" alt="{{ $service->name }}" loading="lazy">
                                <div class="th-overlay"></div>
                            </div>
                            <div class="box-content order-xl-0">
                                <h3 class="box-title">
                                    <a href="{{ route('service.show', $service->slug) }}">{{ $service->name }}</a>
                                </h3>
                                <p class="box-text">{{ Str::limit(strip_tags($service->description), 120) }}</p>
                                <a href="{{ route('service.show', $service->slug) }}" class="th-btn black-border">View Details</a>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-12 text-center">
                        <p>No services available at the moment.</p>
                    </div>
                @endforelse
            </div>
        </div>
    </div>
</section>

<section class="position-relative overflow-hidden space-bottom" id="project-sec">
    <div class="container">
        <div class="row justify-content-between align-items-end">
            <div class="col-xxl-6">
                <div class="title-area">
                    <h2 class="sec-title style6 mt-0 split-text">Our Projects</h2>
                </div>
            </div>
        </div>
    </div>
    <div class="swiper th-slider projectSlide8 overflow-hidden has-shadow" id="projectSlide8"
        data-slider-options='{"loop":true,"loopedSlides":3,"centeredSlides":true,"speed":1500,"keyboard":{"enabled":true},"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":1},"768":{"slidesPerView":1},"992":{"slidesPerView":3}}}'>
        <div class="swiper-wrapper">
            <div class="swiper-slide">
                <div class="project-box2">
                    <div class="box-img global-img">
                        <img src="{{ asset('assets/user/img/project/project_7_1.jpg') }}" alt="A Cube for Life eco-Modern Living, Iranian Soul" title="A Cube for Life eco-Modern Living, Iranian Soul" loading="lazy">
                    </div>
                    <div class="box-wrapp">
                        <div class="box-content">
                            <h3 class="box-title">
                                <a href="{{ url('project-details') }}">A Cube for Life eco-Modern Living, Iranian Soul</a>
                            </h3>
                            <p class="box-text">Scandinavian Hall, Indianapolis</p>
                        </div>
                        <div class="box-number">01</div>
                    </div>
                </div>
            </div>
            <div class="swiper-slide">
                <div class="project-box2">
                    <div class="box-img global-img">
                        <img src="{{ asset('assets/user/img/project/project_7_2.jpg') }}" alt="The Harmony House, Sustainable Serenity" title="The Harmony House, Sustainable Serenity" loading="lazy">
                    </div>
                    <div class="box-wrapp">
                        <div class="box-content">
                            <h3 class="box-title">
                                <a href="{{ url('project-details') }}">The Harmony House, Sustainable Serenity</a>
                            </h3>
                            <p class="box-text">Scandinavian Hall, Indianapolis</p>
                        </div>
                        <div class="box-number">02</div>
                    </div>
                </div>
            </div>
            <div class="swiper-slide">
                <div class="project-box2">
                    <div class="box-img global-img">
                        <img src="{{ asset('assets/user/img/project/project_7_3.jpg') }}" alt="Urban Oasis, Green Innovations" title="Urban Oasis, Green Innovations" loading="lazy">
                    </div>
                    <div class="box-wrapp">
                        <div class="box-content">
                            <h3 class="box-title">
                                <a href="{{ url('project-details') }}">Urban Oasis, Green Innovations</a>
                            </h3>
                            <p class="box-text">Scandinavian Hall, Indianapolis</p>
                        </div>
                        <div class="box-number">03</div>
                    </div>
                </div>
            </div>
            <div class="swiper-slide">
                <div class="project-box2">
                    <div class="box-img global-img">
                        <img src="{{ asset('assets/user/img/project/project_7_1.jpg') }}" alt="A Cube for Life eco-Modern Living, Iranian Soul" title="A Cube for Life eco-Modern Living, Iranian Soul" loading="lazy">
                    </div>
                    <div class="box-wrapp">
                        <div class="box-content">
                            <h3 class="box-title">
                                <a href="{{ url('project-details') }}">A Cube for Life eco-Modern Living, Iranian Soul</a>
                            </h3>
                            <p class="box-text">Scandinavian Hall, Indianapolis</p>
                        </div>
                        <div class="box-number">04</div>
                    </div>
                </div>
            </div>
            <div class="swiper-slide">
                <div class="project-box2">
                    <div class="box-img global-img">
                        <img src="{{ asset('assets/user/img/project/project_7_2.jpg') }}" alt="The Harmony House, Sustainable Serenity" title="The Harmony House, Sustainable Serenity" loading="lazy">
                    </div>
                    <div class="box-wrapp">
                        <div class="box-content">
                            <h3 class="box-title">
                                <a href="{{ url('project-details') }}">The Harmony House, Sustainable Serenity</a>
                            </h3>
                            <p class="box-text">Scandinavian Hall, Indianapolis</p>
                        </div>
                        <div class="box-number">05</div>
                    </div>
                </div>
            </div>
            <div class="swiper-slide">
                <div class="project-box2">
                    <div class="box-img global-img">
                        <img src="{{ asset('assets/user/img/project/project_7_3.jpg') }}" alt="Urban Oasis, Green Innovations" title="Urban Oasis, Green Innovations" loading="lazy">
                    </div>
                    <div class="box-wrapp">
                        <div class="box-content">
                            <h3 class="box-title">
                                <a href="{{ url('project-details') }}">Urban Oasis, Green Innovations</a>
                            </h3>
                            <p class="box-text">Scandinavian Hall, Indianapolis</p>
                        </div>
                        <div class="box-number">06</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

{{-- Why Choose Us Section --}}
<div class="choose-area3 position-relative overflow-hidden space-bottom">
    <div class="container">
        <div class="row gy-5 justify-content-between">
            <div class="col-xl-5">
                <div class="title-area">
                    <span class="sub-title sub-title2">Why Choose Us</span>
                </div>
            </div>
            <div class="col-xl-7">
                <div class="title-area ps-xl-5 ms-xl-5">
                    <h2 class="sec-title style5 split-text mt-0">Creating Eco-Friendly Structures for a Sustainable Tomorrow</h2>
                    <p>Real Estate Architectural Services combine innovation, functionality, and aesthetics to transform visions into reality. These services focus on creating well-planned, sustainable, and visually appealing structures that meet both client goals and regulatory standards.</p>
                </div>
                <div class="choose-progress-bar">
                    <div class="progress-bar">
                        <div class="progress-track">
                            <div class="progress-fill">
                                <span class="counter">85%</span>
                                <p class="text">Renovations & Retrofitting</p>
                            </div>
                        </div>
                    </div>
                    <div class="progress-bar">
                        <div class="progress-track">
                            <div class="progress-fill">
                                <span class="counter">45%</span>
                                <p class="text">Custom Homes</p>
                            </div>
                        </div>
                    </div>
                    <div class="progress-bar">
                        <div class="progress-track">
                            <div class="progress-fill">
                                <span class="counter">55%</span>
                                <p class="text">Modular/Prefab Design</p>
                            </div>
                        </div>
                    </div>
                </div>
                <hr class="choose-bottom-line">
            </div>
        </div>
    </div>
    <div class="shape-mockup d-none d-xl-block" data-bottom="10%" data-left="0%">
        <img src="{{ asset('assets/user/img/normal/choose-img.png') }}" alt="Choose Us Image" title="Choose Us Image" loading="lazy">
    </div>
</div>

{{-- FAQ Section --}}
<div class="space-bottom overflow-hidden" id="faq-sec">
    <div class="container">
        <div class="row gx-0">
            <div class="col-xl-6">
                <div class="faq-area style3">
                    <div class="title-area mb-40">
                        <span class="sub-title style2 text-anime">FAQ’S</span>
                        <h2 class="sec-title split-text">
                            Have Any <span class="text-theme">Question?</span>
                        </h2>
                    </div>
                    <div class="accordion-area accordion" id="faqAccordion3">
                        <div class="accordion-card wow fadeInUp" data-wow-delay=".1s">
                            <div class="accordion-header" id="collapse-item-1">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-1" aria-expanded="false" aria-controls="collapse-1">1. What does an architect do??</button>
                            </div>
                            <div id="collapse-1" class="accordion-collapse collapse" aria-labelledby="collapse-item-1" data-bs-parent="#faqAccordion3">
                                <div class="accordion-body">
                                    <p class="faq-text">Most medical centers offer charity programs, counseling, and financial assistance for those in need. Non-Muslims are welcome to visit mosques. They should dress modestly and remove their shoes upon entering.</p>
                                </div>
                            </div>
                        </div>
                        <div class="accordion-card active wow fadeInUp" data-wow-delay=".3s">
                            <div class="accordion-header" id="collapse-item-2">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-2" aria-expanded="true" aria-controls="collapse-2">2. What is the difference between an architect and an engineer??</button>
                            </div>
                            <div id="collapse-2" class="accordion-collapse collapse show" aria-labelledby="collapse-item-2" data-bs-parent="#faqAccordion3">
                                <div class="accordion-body">
                                    <p class="faq-text">Most medical centers offer charity programs, counseling, and financial assistance for those in need. Non-Muslims are welcome to visit mosques. They should dress modestly and remove their shoes upon entering.</p>
                                </div>
                            </div>
                        </div>
                        <div class="accordion-card wow fadeInUp" data-wow-delay=".5s">
                            <div class="accordion-header" id="collapse-item-3">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-3" aria-expanded="false" aria-controls="collapse-3">3. Do I need an architect for my project?</button>
                            </div>
                            <div id="collapse-3" class="accordion-collapse collapse" aria-labelledby="collapse-item-3" data-bs-parent="#faqAccordion3">
                                <div class="accordion-body">
                                    <p class="faq-text">Most medical centers offer charity programs, counseling, and financial assistance for those in need. Non-Muslims are welcome to visit mosques. They should dress modestly and remove their shoes upon entering.</p>
                                </div>
                            </div>
                        </div>
                        <div class="accordion-card wow fadeInUp" data-wow-delay=".7s">
                            <div class="accordion-header" id="collapse-item-4">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-4" aria-expanded="false" aria-controls="collapse-4">4. How much does it cost to hire an architect?</button>
                            </div>
                            <div id="collapse-4" class="accordion-collapse collapse" aria-labelledby="collapse-item-4" data-bs-parent="#faqAccordion3">
                                <div class="accordion-body">
                                    <p class="faq-text">Most medical centers offer charity programs, counseling, and financial assistance for those in need. Non-Muslims are welcome to visit mosques. They should dress modestly and remove their shoes upon entering.</p>
                                </div>
                            </div>
                        </div>
                        <div class="accordion-card wow fadeInUp" data-wow-delay=".8s">
                            <div class="accordion-header" id="collapse-item-5">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-5" aria-expanded="false" aria-controls="collapse-5">5. What is sustainable or green architecture??</button>
                            </div>
                            <div id="collapse-5" class="accordion-collapse collapse" aria-labelledby="collapse-item-5" data-bs-parent="#faqAccordion3">
                                <div class="accordion-body">
                                    <p class="faq-text">Most medical centers offer charity programs, counseling, and financial assistance for those in need. Non-Muslims are welcome to visit mosques. They should dress modestly and remove their shoes upon entering.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6">
                <div class="faq-image global-img img-anim-right">
                    <img src="{{ asset('assets/user/img/normal/faq-img.jpg') }}" alt="FAQ Image" title="FAQ Image" loading="lazy">
                </div>
            </div>
        </div>
    </div>
    <div class="shape-mockup d-none d-xxl-block" data-bottom="0%" data-right="0%">
        <img src="{{ asset('assets/user/img/shape/bg-element.png') }}" alt="Background Element" title="Background Element" loading="lazy">
    </div>
</div>

{{-- Contact Section --}}
<div class="contact-area3 overflow-hidden space overflow-hidden" id="contact-sec" data-bg-src="{{ asset('img/bg/contact_bg_1.jpg') }}">
    <div class="container">
        <div class="row gy-4 justify-content-between">
            <div class="col-xl-4">
                <div class="title-area">
                    <span class="sub-title style2 text-anime text-white">get in touch</span>
                    <h2 class="sec-title style5 text-white split-text">Transforming Visions Into Reality</h2>
                </div>
            </div>
            <div class="col-xl-6">
                <form method="POST" class="contact-form3">
                    <div class="row">
                        <div class="form-group col-md-6">
                            <input type="text" class="form-control" name="name" id="name" placeholder="Full Name">
                            <i class="fa-solid fa-user"></i>
                        </div>
                        <div class="form-group col-md-6">
                            <input type="email" class="form-control" name="email" id="email" placeholder="Email Address">
                            <i class="fa-solid fa-envelope"></i>
                        </div>
                        <div class="form-group col-12">
                            <input type="tel" class="form-control" name="number" id="number" placeholder="Phone Number">
                            <i class="fa-solid fa-phone"></i>
                        </div>
                        <div class="form-group col-12">
                            <select name="subject" id="subject" class="form-select nice-select">
                                <option value="" disabled selected hidden>Inquire Services</option>
                                <option value="Interior Consulting">Interior Consulting</option>
                                <option value="Decor & Art Design">Decor & Art Design</option>
                                <option value="Exterior Design">Exterior Design</option>
                                <option value="Furniture Design">Furniture Design</option>
                            </select>
                        </div>
                        <div class="form-group col-12">
                            <textarea name="message" id="message" cols="30" rows="3" class="form-control" placeholder="Your Message"></textarea>
                            <i class="fa-solid fa-comment"></i>
                        </div>
                        <div class="col-12 form-group">
                            <input type="checkbox" id="html">
                            <label for="html">I agree with the privacy policy</label>
                        </div>
                        <div class="form-btn mt-20 col-12">
                            <button class="th-btn style4" type="submit">Send Message</button>
                        </div>
                    </div>
                    <p class="form-messages mb-0 mt-3"></p>
                </form>
            </div>
        </div>
    </div>
    <div class="shape-mockup spin d-none d-xxl-block" data-bottom="42%" data-left="14%">
        <img src="{{ asset('assets/user/img/shape/element-8.png') }}" alt="Decorative Shape" title="Decorative Shape" loading="lazy">
    </div>
</div>

{{-- Testimonials Section --}}
<section class="space-top overflow-hidden" id="testi-sec">
    <div class="container">
        <div class="row gy-4 mb-30">
            <div class="col-lg-6">
                <div class="title-area">
                    <span class="sub-title style2 text-anime">Testimonials</span>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="title-area">
                    <h2 class="sec-title style2 split-text">What Our Client’s Say</h2>
                    <p class="fs-18 wow fadeInUp" data-wow-delay=".2s">
                        Real Estate Architectural Services combine innovation, functionality, and aesthetics to transform visions into reality.
                    </p>
                </div>
            </div>
        </div>

        <div class="row space-extra-top">

            @if($testimonials->count() > 0)
                @foreach($testimonials as $testimonial)
                    <div class="testi-item hover-item @if($loop->first) item-active @endif">
                        <div class="testi-item_wrapp">
                            <div class="box-content">
                                <h3 class="box-title">{{ $testimonial->name }}</h3>
                                <span class="box-desig">{{ $testimonial->designation }}</span>
                            </div>
                            <div class="box-img-area">
                                <div class="box-img">
                                    <img src="{{ asset($testimonial->image) }}"alt="{{ $testimonial->name }}"title="{{ $testimonial->name }}" loading="lazy">
                                </div>
                                <p class="box-text">{!! Str::limit(strip_tags($testimonial->description), 200) !!}</p>
                            </div>
                        </div>
                    </div>
                @endforeach

            @else
                <div class="col-12 text-center py-5">
                    <h4>No testimonials available</h4>
                </div>
            @endif

        </div>
    </div>
</section>


{{-- Blog Section --}}
<section class="overflow-hidden space" id="blog-sec">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9 col-xxl-4">
                <div class="title-area text-center">
                    <span class="sub-title text-anime">BLOG & NEWS</span>
                    <h2 class="sec-title style5 split-text">Browse Our Latest Articles & News</h2>
                </div>
            </div>
        </div>

        <div class="row gy-4 gx-147">
            @forelse($blogs as $blog)
            <div class="col-lg-6">
                <div class="blog-card wow fadeInUp">
                    <div class="box-img global-img">
                        <img src="{{ $blog->image ? asset($blog->image) : 'https://via.placeholder.com/600x400.png?text=No+Image' }}" alt="{{ $blog->name }}" title="{{ $blog->name }}" loading="lazy">
                    </div>
                    <div class="box-content">
                        <h3 class="box-title">
                            <a href="{{ route('blog') }}">{{ Str::limit($blog->name, 80) }}</a>
                        </h3>
                    </div>
                    <div class="box-wrapp">
                        <a href="{{ route('blog') }}" class="th-btn black-border">
                            Read More <i class="fa-regular fa-arrow-right ms-2"></i>
                        </a>
                    </div>
                </div>
            </div>
            @empty
            <div class="col-12 text-center py-5">
                <p class="text-muted fs-18">No blogs available at the moment.</p>
            </div>
            @endforelse
        </div>
    </div>
</section>


{{-- Brands Section --}}
<div class="overflow-hidden space-bottom">
    <div class="container">
        <div class="title-area text-center">
            <span class="sub-title style2 text-anime">experience with 1,20000+ Visitors</span>
            <h2 class="sec-title split-text">Our Trusted <span class="text-theme">Brands</span></h2>
        </div>
        <div class="slider-area">
            <div class="swiper th-slider" id="brandSlider1" data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"476":{"slidesPerView":2},"768":{"slidesPerView":2},"992":{"slidesPerView":3},"1200":{"slidesPerView":4},"1400":{"slidesPerView":5}}}'>
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="brand-card">
                            <a href="#">
                                <img class="original" src="{{ asset('assets/user/img/brand/brand_1_1.svg') }}" alt="Brand 1" title="Brand 1" loading="lazy">
                                <img class="gray" src="{{ asset('assets/user/img/brand/brand_1_1.svg') }}" alt="Brand 1" title="Brand 1" loading="lazy">
                            </a>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="brand-card">
                            <a href="#">
                                <img class="original" src="{{ asset('assets/user/img/brand/brand_1_2.svg') }}" alt="Brand 2" title="Brand 2" loading="lazy">
                                <img class="gray" src="{{ asset('assets/user/img/brand/brand_1_2.svg') }}" alt="Brand 2" title="Brand 2" loading="lazy">
                            </a>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="brand-card">
                            <a href="#">
                                <img class="original" src="{{ asset('assets/user/img/brand/brand_1_3.svg') }}" alt="Brand 3" title="Brand 3" loading="lazy">
                                <img class="gray" src="{{ asset('assets/user/img/brand/brand_1_3.svg') }}" alt="Brand 3" title="Brand 3" loading="lazy">
                            </a>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="brand-card">
                            <a href="#">
                                <img class="original" src="{{ asset('assets/user/img/brand/brand_1_4.svg') }}" alt="Brand 4" title="Brand 4" loading="lazy">
                                <img class="gray" src="{{ asset('assets/user/img/brand/brand_1_4.svg') }}" alt="Brand 4" title="Brand 4" loading="lazy">
                            </a>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="brand-card">
                            <a href="#">
                                <img class="original" src="{{ asset('assets/user/img/brand/brand_1_5.svg') }}" alt="Brand 5" title="Brand 5" loading="lazy">
                                <img class="gray" src="{{ asset('assets/user/img/brand/brand_1_5.svg') }}" alt="Brand 5" title="Brand 5" loading="lazy">
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection

@section('scripts')
@endsection
