@extends('user.layout.sub-app')
@section('title', 'All Blogs | Extrutech Hardware')

@php
    $seo = [
        'title' => 'All Blogs | Extrutech Hardware',
        'description' => 'Read the latest news, insights, and architectural solutions from Extrutech Hardware.',
        'keywords' => 'blogs, extrutech news, architectural hardware tips',
        'image' => asset('assets/user/img/extrutech.png'),
        'author' => 'Extrutech Hardware',
        'robots' => 'INDEX,FOLLOW',
        'canonical' => url()->current()
    ];
@endphp

@section('meta')
<meta property="og:type" content="website">
<meta property="og:title" content="{{ $seo['title'] }}">
<meta property="og:description" content="{{ $seo['description'] }}">
<meta property="og:image" content="{{ $seo['image'] }}">
<meta property="og:url" content="{{ $seo['canonical'] }}">
<meta property="og:site_name" content="Extrutech Hardware">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="{{ $seo['title'] }}">
<meta name="twitter:description" content="{{ $seo['description'] }}">
<meta name="twitter:image" content="{{ $seo['image'] }}">
@endsection

@section('schema')
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Blog",
  "name": "Extrutech Hardware Blog",
  "url": "{{ url()->current() }}",
  "description": "{{ $seo['description'] }}",
  "publisher": {
    "@type": "Organization",
    "name": "Extrutech Hardware",
    "logo": {
      "@type": "ImageObject",
      "url": "{{ asset('assets/user/img/extrutech.png') }}"
    }
  }
}
</script>
@endsection

@section('content')
<div class="breadcumb-area" itemscope itemtype="https://schema.org/BreadcrumbList">
    <div class="breadcumb-wrapper" data-bg-src="{{ asset('assets/user/img/bg/breadcumb-bg.jpg') }}">
        <div class="container">
            <div class="breadcumb-content">
                <h1 class="breadcumb-title text-anime" itemprop="name">All Blogs</h1>
                <ul class="breadcumb-menu">
                    <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                        <a href="{{ url('/') }}" itemprop="item"><span itemprop="name">Home</span></a>
                        <meta itemprop="position" content="1" />
                    </li>
                    <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                        <span itemprop="name">All Blogs</span>
                        <meta itemprop="position" content="2" />
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<section class="th-blog-wrapper py-5">
    <div class="container">
        <div class="row g-4">
            @forelse($blogs as $blog)
            <div class="col-lg-6 col-xl-4">
                <div class="th-blog blog-single has-post-thumbnail single-grid">
                    <div class="blog-img global-img">
                        <a href="javascript:void(0)">
                            <img src="{{ $blog->image ? asset($blog->image) : 'https://via.placeholder.com/400x300.png?text=No+Image' }}" 
                                 alt="{{ $blog->name }}" title="{{ $blog->name }}" class="img-fluid">
                        </a>
                    </div>
                    <div class="blog-content">
                        <h2 class="box-title">
                            <a href="javascript:void(0)">{{ $blog->name }}</a>
                        </h2>
                        <p class="box-text">
                            {!! Str::limit(strip_tags($blog->description), 120) !!}
                        </p>
                        <div class="blog-date mt-2">
                            <span class="date">{{ \Carbon\Carbon::parse($blog->created_at)->format('d') }}</span> 
                            <span class="month">{{ \Carbon\Carbon::parse($blog->created_at)->format('M Y') }}</span>
                        </div>
                    </div>
                </div>
            </div>
            @empty
            <div class="col-12 text-center py-5">
                <p class="text-muted fs-18">No blogs available at the moment.</p>
            </div>
            @endforelse
        </div>

        @if($blogs->hasPages())
        <div class="th-pagination text-center mt-30">
            {{ $blogs->links('pagination::bootstrap-5') }}
        </div>
        @endif
    </div>
</section>
@endsection
