@extends('user.layout.sub-app')
@section('title', 'About Us | Extrutech Hardware')
@php
    $seo = [
        'title' => 'Extrutech Hardware | Buy Premium Aluminium Profiles',
        'description' => 'Buy high-quality aluminium architectural hardware & profiles.',
        'keywords' => 'aluminium hardware, extrutech, glass hardware',
        'image' => asset('assets/user/img/extrutech.png'),
        'author' => 'Extrutech Hardware',
        'robots' => 'INDEX,FOLLOW',
        'canonical' => url('/')
    ];
@endphp
@section('meta')
<meta property="og:type" content="website">
<meta property="og:title" content="{{ $seo['title'] }}">
<meta property="og:description" content="{{ $seo['description'] }}">
<meta property="og:image" content="{{ $seo['image'] }}">
<meta property="og:url" content="{{ $seo['canonical'] }}">
<meta property="og:site_name" content="Extrutech Hardware">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="{{ $seo['title'] }}">
<meta name="twitter:description" content="{{ $seo['description'] }}">
<meta name="twitter:image" content="{{ $seo['image'] }}">
@endsection

@section('content')
    <!-- Breadcrumb -->
    <div class="breadcumb-area" itemscope itemtype="https://schema.org/BreadcrumbList">
        <div class="breadcumb-wrapper" data-bg-src="{{ asset('assets/user/img/bg/breadcumb-bg.jpg') }}">
            <div class="container">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title text-anime" itemprop="name">About Our Firm</h1>
                    <ul class="breadcumb-menu">
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <a href="{{ url('/') }}" itemprop="item"><span itemprop="name">Home</span></a>
                            <meta itemprop="position" content="1" />
                        </li>
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <span itemprop="name">About us</span>
                            <meta itemprop="position" content="2" />
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <!-- About Section 1 -->
    <div class="overflow-hidden overflow-hidden space-top">
        <div class="container">
            <div class="about-area2">
                <div class="row align-items-center flex-row-reverse">

                    <div class="col-xl-7">
                        <div class="about-area3">
                            <div class="title-area mb-30 text-center text-sm-start">
                                <span class="sub-title style3 text-anime">More About Our Company</span>
                                <h2 class="sec-title style4 split-text">
                                    {{ $aboutus->title ?? 'Building Innovating Solutions' }}
                                </h2>
                            </div>

                            <div class="about-description-content">
                                {!! $aboutus->description ?? '' !!}
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-5">
                        <div class="img-box5">
                            <div class="img1 global-img img-anim-left">
                                <img class="w-100"
                                    src="{{ $aboutus->image1 ? asset($aboutus->image1) : asset('assets/user/img/normal/about_6_1.jpg') }}"
                                    alt="{{ $aboutus->title ?? 'About' }}" />
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="counter-area2 space-bottom overflow-hidden">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="title-area text-center text-md-start">
                        <span class="sub-title style3 text-anime">Experience with 120k Visitors</span>
                        <h2 class="sec-title style4 split-text">Our Featured Facilities</h2>
                        <p class="wow fadeInUp" data-wow-delay=".3s">
                            Our practice is Designing Complete Environments™—exceptional buildings, communities and places—in special situations, where a unique historic or natural environment requires an especially thoughtful and innovative solution.
                        </p>
                    </div>
                </div>
                <div class="counter-card_wrapp style3">
                    <div class="counter-card style5 wow fadeInUp" data-wow-delay=".2s">
                        <h3 class="box-number"><span class="counter-number">98</span>%</h3>
                        <p class="box-text">happy customer</p>
                    </div>
                    <div class="counter-card style5 wow fadeInUp" data-wow-delay=".4s">
                        <h3 class="box-number"><span class="counter-number">4.9</span></h3>
                        <p class="box-text">average reviews</p>
                    </div>
                    <div class="counter-card style5 wow fadeInUp" data-wow-delay=".5s">
                        <h3 class="box-number"><span class="counter-number">1.6</span>k+</h3>
                        <p class="box-text">Complete Project</p>
                    </div>
                    <div class="counter-card style5 wow fadeInUp" data-wow-delay=".6s">
                        <h3 class="box-number"><span class="counter-number">126</span></h3>
                        <p class="box-text">Award Win</p>
                    </div>
                </div>
            </div>
            <div class="shape-mockup d-none d-md-block" data-bottom="0%" data-right="0%">
                <img src="{{ asset('assets/user/img/normal/counter-img.jpg') }}" alt="" />
            </div>
        </div>
    </div>

    <!-- Team Section -->
    <section class="team-sec space overflow-hidden">
        <div class="container z-index-common">
            <div class="row justify-content-center">
                <div class="col-xl-6">
                    <div class="title-area text-center">
                        <span class="sub-title style3 text-anime">Our Teams</span>
                        <h2 class="sec-title style4 split-text">Our Team Member</h2>
                    </div>
                </div>
            </div>
            <div class="slider-area">
                <div class="swiper th-slider has-shadow" id="teamSlider3"
                     data-slider-options='{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":3},"1400":{"slidesPerView":4}}}'>
                    <div class="swiper-wrapper">
                        <!-- Repeat as needed -->
                        <div class="swiper-slide">
                            <div class="th-team team-item">
                                <div class="box-img">
                                    <img src="{{ asset('assets/user/img/team/team_3_1.png') }}" alt="Team" />
                                </div>
                                <div class="box-content">
                                    <div>
                                        <h3 class="box-title"><a href="#">Jack Mack Daniel</a></h3>
                                        <span class="team-desig">Manager</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Add more team members same way -->
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="position-relative overflow-hidden space" id="service-sec">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="title-area">
                        <h2 class="sec-title style3 split-text">Our Services...</h2>
                    </div>
                </div>
            </div>

            <div class="service-area3">
                <div class="row gy-4 justify-content-center">

                    @forelse($services as $index => $service)
                        <div class="col-md-6 col-xl-4">
                            <div class="service-item wow fadeInUp" data-wow-delay=".{{ 1 + ($index * 2) }}s">
                                <div class="box-content">

                                    <!-- Yeh ab 100% DYNAMIC ICON hai -->
                                    <div class="box-icon">
                                        <img src="{{ $service->image ? asset($service->image) : asset('assets/user/img/icon/service_3_1.svg') }}" 
                                            alt="{{ $service->name }} Icon"
                                            class="img-fluid">
                                    </div>

                                    <h3 class="box-title">
                                        <a href="{{ url('/service/' . $service->slug) }}">
                                            {{ $service->name }}
                                        </a>
                                    </h3>

                                    <p class="box-text">
                                        {{ Str::limit(strip_tags($service->description), 120, '...') }}
                                    </p>

                                    <a href="{{ url('/service/' . $service->slug) }}" class="line-btn">
                                        Read More <i class="fa-regular fa-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="col-12 text-center py-5">
                            <p class="text-muted fs-18">No services available at the moment.</p>
                        </div>
                    @endforelse

                </div>
            </div>
        </div>
    </section>

    <div class="overflow-hidden space overflow-hidden" data-bg-src="{{ asset('assets/user/img/bg/gallery_bg_1.jpg') }}">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-7">
                    <div class="title-area text-center">
                        <span class="sub-title style2 text-anime">recent gallery</span>
                        <h2 class="sec-title split-text">
                            Through a Unique Combination of
                            <span class="text-theme">Engineering</span>
                        </h2>
                    </div>
                    <div class="filter-menu indicator-active mb-60 filter-menu-active">
                        <button data-filter="*" class="tab-btn active" type="button">View All</button>
                        <button data-filter=".cat1" class="tab-btn" type="button">Interior</button>
                        <button data-filter=".cat2" class="tab-btn" type="button">Architecture</button>
                        <button data-filter=".cat3" class="tab-btn" type="button">Building</button>
                        <button data-filter=".cat4" class="tab-btn" type="button">Exterior</button>
                        <button data-filter=".cat5" class="tab-btn" type="button">Shape</button>
                    </div>
                </div>
            </div>

            <div class="row gy-4 gallery-row filter-active">
                @php
                    $galleries = [
                        ['image'=>'gallery_2_1.jpg','title'=>'Open Kitchen Interior Design','cats'=>['cat2','cat5']],
                        ['image'=>'gallery_2_2.jpg','title'=>'Open Kitchen Interior Design','cats'=>['cat3','cat2']],
                        ['image'=>'gallery_2_3.jpg','title'=>'Open Kitchen Interior Design','cats'=>['cat3','cat5']],
                        ['image'=>'gallery_2_4.jpg','title'=>'Open Kitchen Interior Design','cats'=>['cat1','cat5']],
                        ['image'=>'gallery_2_5.jpg','title'=>'Open Kitchen Interior Design','cats'=>['cat4','cat2','cat1']],
                        ['image'=>'gallery_2_6.jpg','title'=>'Open Kitchen Interior Design','cats'=>['cat4','cat3','cat1']],
                    ];
                @endphp

                @foreach($galleries as $gallery)
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item {{ implode(' ', $gallery['cats']) }}">
                    <div class="gallery-card">
                        <div class="box-img global-img">
                            <img class="wow clippy-img" src="{{ asset('assets/user/img/gallery/'.$gallery['image']) }}" 
                                alt="{{ $gallery['title'] }}" title="{{ $gallery['title'] }}" />
                            <a href="{{ asset('assets/user/img/gallery/'.$gallery['image']) }}" class="icon-btn th-popup-image">
                                <i class="far fa-plus"></i>
                            </a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">{{ $gallery['title'] }}</h2>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>

    <section class="choose-area overflow-hidden space-top overflow-hidden">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="title-area text-center">
                        <span class="sub-title style4 text-white">Why Choose Us</span>
                        <h3 class="sec-title split-text text-white">Why Should You Choose Us</h3>
                    </div>
                </div>
            </div>
            <hr />

            @php
                $chooseUs = [
                    ['icon'=>'choose_2_1.svg','title'=>'Design Excellence','text'=>'We blend creativity with technical mastery to deliver iconic, functional, and timeless architecture...'],
                    ['icon'=>'choose_2_2.svg','title'=>'Client-Centered Approach','text'=>'We blend creativity with technical mastery to deliver iconic, functional, and timeless architecture...'],
                    ['icon'=>'choose_2_3.svg','title'=>'Customer-Focused Design','text'=>'We blend creativity with technical mastery to deliver iconic, functional, and timeless architecture...'],
                    ['icon'=>'choose_2_4.svg','title'=>'Sustainable Innovation','text'=>'We blend creativity with technical mastery to deliver iconic, functional, and timeless architecture...'],
                    ['icon'=>'choose_2_1.svg','title'=>'Design Excellence','text'=>'We blend creativity with technical mastery to deliver iconic, functional, and timeless architecture...'],
                    ['icon'=>'choose_2_2.svg','title'=>'Client-Centered Approach','text'=>'We blend creativity with technical mastery to deliver iconic, functional, and timeless architecture...'],
                ];
            @endphp

            <div class="slider-wrap mt-60">
                <div class="swiper th-slider has-shadow" id="chooseSlide" data-slider-options='{"loop":false,"paginationType": "progressbar","spaceBetween": 70,"mousewheel": {"enabled": true,"sensitivity": 4,"releaseOnEdges":true},"breakpoints": {"0":{"slidesPerView": 1},"576": {"slidesPerView": 1},"768": {"slidesPerView": 2},"992": {"slidesPerView": 2},"1200": {"slidesPerView": 3},"1400": {"slidesPerView": 4}}}'>
                    <div class="swiper-wrapper">
                        @foreach($chooseUs as $item)
                        <div class="swiper-slide">
                            <div class="choose-box">
                                <div class="box-icon">
                                    <img src="{{ asset('assets/user/img/icon/'.$item['icon']) }}" alt="{{ $item['title'] }}" title="{{ $item['title'] }}" />
                                </div>
                                <div class="box-content">
                                    <h3 class="box-title text-white">{{ $item['title'] }}</h3>
                                    <p class="box-text">{{ $item['text'] }}</p>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <div class="marquee-content style2 positive-relative overflow-hidden">
                <div class="marquee">
                    @for($i=0;$i<2;$i++)
                    <div class="marquee-group style3">
                        @for($j=0;$j<2;$j++)
                        <div class="item">
                            <img src="{{ asset('assets/user/img/shape/timeline.png') }}" alt="Timeline" title="Timeline" />
                        </div>
                        @endfor
                    </div>
                    @endfor
                </div>
            </div>
        </div>
    </section>

@endsection

@section('scripts')
    <!-- Agar koi custom JS hai to yahan add karna -->
@endsection