@extends('admin.layout.app')

@section('content')

<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">VendorStatement Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ VendorStatement Details</span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
                <div class="d-flex my-xl-auto right-content" style="margin-right: 15px;">
                    <div id="reportrange"  class="date_picker_range">
                        <i class="far fa-calendar-alt"></i>&nbsp;
                        <span>Date Filter</span> <b class="caret"></b>
                        <i class="fas fa-caret-down float-right"></i>
                        <input type="hidden" name="startDate" id="startDate" value="" />
                        <input type="hidden" name="endDate" id="endDate" value="" />
                    </div>
                </div>
                <div class="d-flex my-xl-auto right-content">
                    <div class="pe-1 mb-xl-0">
                      <a href="{{ url('admin/vendorstatement/create') }}"><button type="button" class="btn btn-primary">Add VendorStatement</button></a>
                   </div>
              </div>
            </div>
            
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">VendorStatement Details</h4>
                           
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive ">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th>SR</th>
                                        <th >Vendor Name</th>
                                        <th >Contact No.</th>
                                        <th >Total Credit</th>
                                        <th >Total Debit</th>
                                        <th >Balance</th>
                                        <!-- <th >Total To Be Paid</th> -->
                                        <!-- <th >Total Pending</th> -->
                                        <th >Statement</th>
                                        <!-- <th >Action</th> -->
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $sr = 1;
                                        
                                    @endphp
                                    @foreach($vendors as $r)
                                        @php
                                    
                                            $debit = App\Models\VendorPayment::where('vendor_id',$r->id);
                                                        if (!empty($start_date)) {
                                                            if (!empty($end_date)) {
                                                                $debit->where('created_at', '>=', date('Y-m-d 00:00:00',strtotime($start_date)));
                                                            } else {
                                                                $debit->where('created_at', '=',  date('Y-m-d 00:00:00',strtotime($start_date)));
                                                            }
                                                        }
                                                        if (!empty($end_date)) {
                                                            $debit->where('created_at', '<=',  date('Y-m-d 23:59:59',strtotime($end_date)));
                                                        }
                                                    $debit = $debit->sum('amount');
                                            $credit = App\Models\VendorAccount::select('vendor_accounts.*','phonenumbers.vendor_rate','orders.payment_status')
                                                                ->leftjoin('phonenumbers','phonenumbers.id','vendor_accounts.product_id')
                                                                ->where('vendor_accounts.vendor_id', $r->id)
                                                                ->where('vendor_accounts.payment_elegible','!=', 'C')
                                                                ->where('vendor_accounts.payment_status','!=', 'C');
                                                                if (!empty($start_date)) {
                                                                    if (!empty($end_date)) {
                                                                        $credit->where('vendor_accounts.created_at', '>=', date('Y-m-d 00:00:00',strtotime($start_date)));
                                                                    } else {
                                                                        $credit->where('vendor_accounts.created_at', '=',  date('Y-m-d 00:00:00',strtotime($start_date)));
                                                                    }
                                                                }
                                                                if (!empty($end_date)) {
                                                                    $credit->where('vendor_accounts.created_at', '<=',  date('Y-m-d 23:59:59',strtotime($end_date)));
                                                                }
                                            $credit = $credit->sum('phonenumbers.vendor_rate');
                                        
                                        @endphp
                                        <tr>
                                            <td>{{$sr}}</td>
                                            <td>{{ $r->name }}</td>
                                            <td>{{ $r->mobile }}</td>
                                        
                                            <td><a href="{{url('/admin/vendorcredit?vendorid='.$r->id)}}" target="_blank">{{$credit??""}}</a></td>
                                            
                                            <td><a href="{{url('admin/vendordebit/'.$r->id)}}" target="_blank">{{$debit??""}}</a></td>
                                            <td>{{$credit - $debit}}</td>
                                            <!-- <td></td>     -->
                                            <!-- <td></td>
                                            <td></td> -->
                                            <td>
                                                <a href="{{url('admin/vendorStatementDownload?vendorid='.$r->id.'&startDate='.$start_date.'&endDate='.$end_date)}}" target="_blank" class="" style="color:blue;">
                                                    <i class="fas fa-file"></i>
                                                </a>
                                            </td>
                                            
                                        </tr>
                                        @php
                                            $sr++
                                        @endphp
                                    @endforeach
                                    <tfoot>
                                        <tr>
                                                @php
                                                    $debit = App\Models\VendorPayment::select('vendor_payments.*');
                                                                if (!empty($start_date)) {
                                                                    if (!empty($end_date)) {
                                                                        $debit->where('created_at', '>=', date('Y-m-d 00:00:00',strtotime($start_date)));
                                                                    } else {
                                                                        $debit->where('created_at', '=',  date('Y-m-d 00:00:00',strtotime($start_date)));
                                                                    }
                                                                }
                                                                if (!empty($end_date)) {
                                                                    $debit->where('created_at', '<=',  date('Y-m-d 23:59:59',strtotime($end_date)));
                                                                }
                                                    $debit = $debit->sum('amount');
                                                    $credit = App\Models\VendorAccount::join('orderdetails', function ($join) {
                                                                    $join->on('orderdetails.order_id', '=', 'vendor_accounts.order_id')
                                                                        ->on('orderdetails.product_id', '=', 'vendor_accounts.product_id');
                                                                    })
                                                                    ->join('orders', 'orders.id', '=', 'orderdetails.order_id')
                                                                    ->where('orders.payment_status', 'Paid');
                                                                    if (!empty($start_date)) {
                                                                        if (!empty($end_date)) {
                                                                            $credit->where('vendor_accounts.created_at', '>=', date('Y-m-d 00:00:00',strtotime($start_date)));
                                                                        } else {
                                                                            $credit->where('vendor_accounts.created_at', '=',  date('Y-m-d 00:00:00',strtotime($start_date)));
                                                                        }
                                                                    }
                                                                    if (!empty($end_date)) {
                                                                        $credit->where('vendor_accounts.created_at', '<=',  date('Y-m-d 23:59:59',strtotime($end_date)));
                                                                    }
                                                    $credit = $credit->sum('orderdetails.vendor_rate');
                                                                    $totalbalance = $credit - $debit;
                                                @endphp
                                            <th></th>
                                            <th>All Vendor</th>
                                            <th>Total</th>
                                            <th>{{$credit}}</th>
                                            <th>{{$debit}}</th>
                                            <th>{{$totalbalance}}</th>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->



@endsection
@section('js')
<script>
   jQuery(document).ready(function () {
    $("#example1").DataTable({
      "responsive": true, "lengthChange": true, "autoWidth": false, "pageLength": 25,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

    $("body").on("change", "#statusToggle", function () {
        Swal.fire({
            title: "Are you sure?",
            text: "you want to Deactivate this VendorStatement ?",
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, confirm it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var id = $(this).data('id');
                var currentStatus = jQuery(this).data('status');
                jQuery.ajax({
                    url: "{{ url('admin/vendorstatement') }}/" + id ,
                    type: 'PUT',
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "id": id,
                        "currentStatus": currentStatus,
                    },
                    success: function (data) {
                        if(data.result == 1)
                        oTable.ajax.reload();
                        toastr.success(data.message);

                        jQuery('#statusToggle').data('status', data.status);
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });
            }else{
                oTable.ajax.reload();
            }
        });   
    });

    $("#example1").on('click', '.data-delete', function () {
        Swal.fire({
            title: "Are you sure?",
            text: "Do you want to delete this record?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var obj = jQuery(this);
                var id = obj.attr('data-id');
                $.ajax({
                    type: "DELETE",
                    url: "{{ url('admin/vendorstatement')  }}/" + id,
                    data: {
                        id: id,
                        _token: "{{ csrf_token() }}"
                    },
                    dataType: 'json',
                    beforeSend: function () {
                        $(this).attr('disabled', true);
                        $('.alert .msg-content').html('');
                        $('.alert').hide();
                    },
                    success: function (resp) {
                        if(resp.success == true){
                            oTable.ajax.reload();
                            toastr.success(resp.message);
                        }
                    },
                    error: function (e) {
                        alert('Error: ' + e);
                    }
                });
            }else{
                oTable.ajax.reload();
            }
        });
    });
		
});
$(function () {    	 
    var start = moment().subtract(29, 'days');
	    var end = moment();
	    $('#reportrange').daterangepicker({
	        startDate: start,
	        endDate: end,
	        ranges: {
	           'Today': [moment(), moment()],
	           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
	           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
	           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
	           'This Month': [moment().startOf('month'), moment().endOf('month')],
	           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
	        }
	    }, 
	    function cb(start, end) {
	        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
	            $('#startDate').val(start.format('DD-MM-YYYY'));
                $('#endDate').val(end.format('DD-MM-YYYY'));
                var startDate = $('#startDate').val();
                var endDate = $('#endDate').val();
                var url = '{{ url("admin/vendorstatement") }}?startDate=' + startDate + '&endDate=' + endDate;
                window.location.href = url;
	    }
	    )
});
</script>
@endsection