@extends('admin.layout.app')

@section('content')
<style>
.dt-buttons.btn-group {
    position: absolute;
    top: 50px;
    left: 178px;
}
</style>
<input type="hidden" id="vendor_id" value="{{$vendor_id}}">
<div class="main-content app-content">
    <div class="main-container container-fluid">
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Vendor Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Vendor Details</span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
				  <div class="pe-1 mb-xl-0">
                    {{-- <a href="#"><button type="button" class="btn btn-primary">Update Status</button></a> --}}
				 </div>
            </div> 
        </div>
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Vendor Details</h4>
                            
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th >SR No</th>
                                        <th >Vendor Name</th>
                                        <th >Txn Id</th>
                                        <th >Amount</th>
                                        <th >Payment Mode</th>
                                        <th >Payment Date</th>
                                        <th >Remarks</th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                            
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
// $(document).ready(function () {
//     $('.js-example-basic-multiple').select2();
// });
jQuery(document).ready(function () {
   
    var id = $('#vendor_id').val();
    
    var oTable = $('#example1').DataTable({
            "responsive": true, "lengthChange": true, "autoWidth": false, "pageLength": 25,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"],
            processing: true,
            serverSide: true,
            dom:'lBfrtip',
			ajax:{ 
                url: "{{ url('admin/vendordebit') }}/"+id,
                type: 'get',
                data: {
                    "_token": "{{ csrf_token() }}",
                    "vendor_id": id,
                },
             },
			columns: [
				{data: 'sr_no', name: 'sr_no', searchable: false,className : 'text-center'},
                {data: 'vendor.name', name: 'vendor.name',defaultContent:'-',orderable : false,className : 'text-center'},
                {data: 'txn_id', name: 'txn_id', searchable: false,orderable : false,className : 'text-center'},
				{ data: 'amount', name: 'amount', defaultContent: '-',orderable : false,className : 'text-center' },
                {data: 'payment_mode', name: 'payment_mode', searchable: false,orderable : false,className : 'text-center'},
				{data: 'payment_date', name: 'payment_date', searchable: false,orderable : false,className : 'text-center'},
				{data: 'remarks', name: 'remarks', searchable: false,orderable : false,className : 'text-center'},
				{data: 'action', name: 'action', searchable: false, orderable : false,className : 'text-center'},
			]
    });

  
   
		
});
$("#example1").on('click', '.data-delete', function () {
        Swal.fire({
            title: "Are you sure?",
            text: "Do you want to delete this record?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var obj = jQuery(this);
                var id = obj.attr('data-id');
                $.ajax({
                    type: "DELETE",
                    url: "{{ url('admin/vendorpayment')  }}/" + id,
                    data: {
                        id: id,
                        _token: "{{ csrf_token() }}"
                    },
                    dataType: 'json',
                    beforeSend: function () {
                        $(this).attr('disabled', true);
                        $('.alert .msg-content').html('');
                        $('.alert').hide();
                    },
                    success: function (resp) {
                        if(resp.success == true){
                            oTable.ajax.reload();
                            toastr.success(resp.message);
                        }
                    },
                    error: function (e) {
                        alert('Error: ' + e);
                    }
                });
            }else{
                oTable.ajax.reload();
            }
        });
    });
		

</script>
@endsection