@extends('admin.layout.app')

@section('content')

<div class="main-content app-content">
    <div class="main-container container-fluid">
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Vendor Product Delete</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ Vendor Product Delete</span>
                </div>
            </div>
        </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">
                            Vendor Product Delete
                        </h4>
                        <p class="mb-2"></p>
                    </div>
                    <form action="{{url('admin/deleteallvendor')}}" method="POST">
                        @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group {{ $errors->has('vendor_id') ? ' has-error' : '' }}">
                                    <label for="name" class="form-label text-dark">Vendor Name</label>
                                    <select class="form-control js-example-basic-multiple" name="vendor_id">
                                        <option value="">Choose One</option>
                                        @foreach($vendors as $vendor)
                                            <option value="{{$vendor->id}}">{{$vendor->name??''}}</option>
                                        @endforeach
                                    </select>
                                    @error('vendor_id')
                                        <div style="color:red">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer ">               
                        <button type="submit" class="btn btn-primary float-end mb-3">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
	</div>
</div>
@endsection
@section('js')
<script>
$(document).ready(function () {
    $('.js-example-basic-multiple').select2();
});
</script>
@endsection