@extends('admin.layout.app')

@section('content')

<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Team Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ View Teams</span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
				  <div class="pe-1 mb-xl-0">
                    <a href="{{ url('admin/team/create') }}"><button type="button" class="btn btn-primary">Add Team</button></a>
				 </div>
            </div>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Team TABLE</h4>
                        </div>
                        <p class="tx-12 tx-gray-500 mb-2"></p>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th class="wd-lg-8p"><span>Title</span></th>
                                        <th class="wd-lg-20p"><span>Image</span></th>
                                        <th class="wd-lg-20p"><span>Status</span></th>
                                        <th class="wd-lg-20p">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
								@foreach($result as $r)
                                    <tr>
									
                                        <td>
										{{ $r->name }}
                                        </td>
                                        <td><img src="{{$r->image_url??""}}"></td>
                                        <td>
                                            <div class="form-check form-switch">
											     <input class="form-check-input" style="margin:auto;" type="checkbox" role="switch" id="statusToggle" data-id="{{ $r->id }}" data-status="{{ $r->status }}" {{$r->status == 'Active'?'checked':''}}>
											  <label class="form-check-label" for="statusToggle"></label>
											</div>
                                        </td>
                                       
                                        
                                        <td>
                                            <a href="{{url('admin/team/'.$r->id)}}" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="" data-bs-original-title="view">
                                                <i class="fe fe-eye"></i>
                                            </a>
                                            <a href="{{url('admin/team/'.$r->id.'/edit')}}" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit">
                                                <i class="fe fe-edit"></i>
                                            </a>
                                            <button  class="btn btn-sm btn-danger data-delete" data-id="{{$r->id}}"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete">
                                                <i class="fe fe-trash-2"></i>
                                            </button>
                                        </td>
										
                                    </tr>
									@endforeach
                                </tbody>
                            </table>
                        </div>
						{{ $result->links() }}
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->



@endsection
@section('js')
<script>
    $("#example1").DataTable({
      "responsive": true, "lengthChange": true, "autoWidth": false,"pageLength": 25,
      
    });
   jQuery(document).ready(function () {
        jQuery('#statusToggle').change(function () {
            var id = $(this).data('id');
            var currentStatus = jQuery(this).data('status');

            jQuery.ajax({
                url: "{{ url('admin/team') }}/" + id ,
                type: 'PUT',
                data: {
					"_token": "{{ csrf_token() }}",
					"id": id,
					"currentStatus": currentStatus,
				},
                success: function (data) {
                  if(data == 1)
                    jQuery('#statusToggle').data('status', data.status);
                },
                error: function (xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        });
		
    jQuery(".data-delete").on("click", function () {
        var obj = jQuery(this);
        var id = obj.attr('data-id');

        if (confirm("Are you sure to Delete Data?")) {
            jQuery.ajax({
                type: "POST",
                url: "{{ url('admin/teamdelete')  }}/" + id,
                data: {
                    id: id,
                    _token: "{{ csrf_token() }}"
                },
                dataType: 'json',
                beforeSend: function () {
                    // Use the stored reference to the clicked element
                    obj.attr('disabled', true);
                    jQuery('.alert .msg-content').html('');
                    jQuery('.alert').hide();
                },
                success: function (resp) {
                    if(resp == 1)
                    {
                    window.location.reload();
                    }
                }
                
            });
        }
    });
		
    });
</script>
@endsection