@extends('admin.layout.app')

@section('content')
<style>
.dt-buttons.btn-group {
    position: absolute;
    top: 50px;
    left: 178px;
}
</style>

<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Search Orders</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Search Orders</span>
                </div>
            </div>
            
             <div class="d-flex my-xl-auto right-content">
                <div class="d-flex my-xl-auto right-content" style="margin-right: 15px;">
                    <div id="reportrange"  class="date_picker_range">
                        <i class="far fa-calendar-alt"></i>&nbsp;
                        <span>Date Filter</span> <b class="caret"></b>
                        <i class="fas fa-caret-down float-right"></i>
                        <input type="hidden" name="startDate" id="startDate" value="" />
                        <input type="hidden" name="endDate" id="endDate" value="" />
                    </div>
                </div>
				  <!-- <div class="pe-1 mb-xl-0">
                    <a href="{{ url('admin/order/create') }}"><button type="button" class="btn btn-primary">New Order</button></a>
				 </div> -->
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">Search Order</h4>
                        <p class="mb-2"></p>
                    </div>
                    <div class="card-body pt-0">

                    <form action="" method="get">
                        <div class="row">
                            <div class="col-md-2">
                                <div class="control-group form-group {{ $errors->has('order_id') ? ' has-error' : '' }}">
                                    <label class="form-label">Order Id</label>
                                    <div class="input-group">
                                        <input class="form-control " name="order_id" id="order_id" autocomplete="off"  type="text" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group {{ $errors->has('customer_id') ? ' has-error' : '' }}">
                                    <label for="customer_id" class="form-label text-dark">Customer</label>
                                    <select class="form-control form-select customer_id" name="customer_id" id="customer_id" required="required">
                                        <option value="">Choose One</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="control-group form-group {{ $errors->has('mobile_no') ? ' has-error' : '' }}">
                                    <label class="form-label">Mobile No</label>
                                    <div class="input-group">
                                        <input class="form-control " name="mobile_no" id="mobile_no" autocomplete="off"  type="text" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="control-group form-group {{ $errors->has('vanity_number') ? ' has-error' : '' }}">
                                    <label class="form-label">Vanity Number</label>
                                    <div class="input-group">
                                        <input class="form-control " name="vanity_number" id="vanity_number" autocomplete="off"  type="text" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="control-group form-group {{ $errors->has('status') ? ' has-error' : '' }}">
                                    <div class="form-group">
                                        <label class="form-label">Status</label>
                                        <select name="status" id="status"  class="form-control form-select js-example-basic-multiple" data-bs-placeholder="Status" required="required">
                                            <option value="">------Select-----</option>
                                            <option value="new_order" >New</option>
                                            <option value="call_back" >Call Back</option>
                                            <option value="not_contacted" >Not Contacted</option>
                                            <option value="inprocess" >Inprocess</option>
                                            <option value="Follow up" >Follow up</option>
                                            <option value="on_hold" >ON Hold</option>
                                            <option value="closed_won" >Convert to Order</option>
                                            <option value="closed_lost" >Closed Lost</option>
                                            <option value="language_barrier" >Language Barrier</option>
                                            <option value="duplicate">Duplicate</option>
                                            <option value="test" >Test</option>
                                            <option value="cancelled" >Cancelled</option>
                                            <option value="wrong_data" >Wrong Data</option>
                                            <option value="to_be_refund" >To Be Refund</option>
                                            <option value="refund" >Refund</option>
                                            <option value="UPC_Error" >UPC Error</option>
                                            <option value="transfer" >Transfer Order</option>
                                            <option value="teleduce" >Teleduce</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="control-group form-group {{ $errors->has('email_id') ? ' has-error' : '' }}">
                                    <label class="form-label">Email Id</label>
                                    <div class="input-group">
                                        <input class="form-control " name="email_id" id="email_id" autocomplete="off"  type="text" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="control-group form-group {{ $errors->has('email_id') ? ' has-error' : '' }}">
                                    <label class="form-label">Order Price</label>
                                    <div class="input-group">
                                        <input class="form-control " name="order_price" id="order_price" autocomplete="off"  type="text" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    </div>
                    <div class="card-footer ">
                        <button type="button" class="btn btn-primary float-end mb-3" id="yourButtonId">Submit</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Order Details </h4>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered" id="example1">
                                <thead>
                                    <tr>
                                        <th >SR No</th>
                                        <th >Order ID</th>
                                        <th >Customer Details</th>
                                        <th >Mobile No</th> 
                                        <th >Order Date</th>
                                        <th >Updated Date</th>
                                        <th >Purchase Detail</th>
                                        <th >Order Total</th>
                                        <th >Payment Status</th>
                                        <th >Order Status</th>
                                        <th >Assign To</th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                            
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
    </div>
</div>




@endsection
@section('js')


<script>
function openCustomerPopup(event, url) {
    event.preventDefault();
    window.open(url, '_blank', 'height=600,width=800,left=150,top=150,titlebar=no,toolbar=no,addressbar=no,menubar=no,location=no,resizable=no');
    return false;
}
function openPurchasePopup(event, url) {
    event.preventDefault(); 
    window.open(url, '_blank', 'height=600,width=1000,left=150,top=150,titlebar=no,toolbar=no,addressbar=no,menubar=no,location=no,resizable=no');
    return false;
}
$(document).ready(function () {
    $('.js-example-basic-multiple').select2();
    function initSelect2() {
        $('.customer_id').select2({
            placeholder: "Select a customer",
            allowClear: true,
            ajax: {
                url: "{{ url('admin/getcustomer_search') }}",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: $.trim(params.term) // search term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });
        var defaultOption = new Option("Select a customer", "", true, true);
        $('.customer_id').append(defaultOption).trigger('change');
    }

    initSelect2();
    $('.customer_id').on('select2:clear', function (e) {
        $(this).empty();
        initSelect2();
    });
  
});
 
function initializeDataTable(){
    if ($.fn.DataTable.isDataTable('#example1')) {
        $('#example1').DataTable().clear().destroy();
    }
    var status = $('#status').val();
    var order_id = $('#order_id').val();
    var customer_id = $('#customer_id').val();
    var mobile_no = $('#mobile_no').val();
    var vanity_number = $('#vanity_number').val();
    var status = $('#status').val();
    var startDate = $('#startDate').val();
    var endDate = $('#endDate').val();
    var email_id = $('#email_id').val();
    var order_price = $('#order_price').val();
    var oTable = $('#example1').DataTable({
            "responsive": true, "lengthChange": true, "autoWidth": false, "pageLength": 25,
            // "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"],
            processing: true,
            serverSide: true,
            // dom:'lBfrtip',
            ajax:{ 
                url: "{{ url('admin/searchorder') }}",
                type: 'get',
                data: function (d) {
                    d._token = "{{ csrf_token() }}";
                    d.order_id = order_id;
                    d.customer_id = customer_id;
                    d.mobile_no = mobile_no;
                    d.vanity_number = vanity_number;
                    d.status = status;
                    d.email_id = email_id;
                    d.order_price = order_price;
                    d.startDate = $('#startDate').val();
                    d.endDate = $('#endDate').val();
                    d.search = {
                        value: $('input[type="search"]').val()  
                    };
                },
            },
            columns: [
                {data: 'sr_no', name: 'sr_no', searchable: false,className : 'text-center'},
                {data: 'order_number', name: 'order_number',orderable : false,searchable:false,className : 'text-center'},
                {data: 'customer', name: 'customer', searchable: false,orderable : false,className : 'text-center', defaultContent: '-'},
                {data: 'mobile_no', name: 'mobile_no',orderable : false,searchable:false,className : 'text-center'},
                {data: 'created_at', name: 'created_at', searchable: false,orderable : false,className : 'text-center'},
                {data: 'updated_at', name: 'updated_at', searchable: false,orderable : false,className : 'text-center'},
                {data: 'purchase_details', name: 'purchase_details', searchable: false,orderable : false,className : 'text-center'},
                {data: 'order_total', name: 'order_total', searchable: false,orderable : false,className : 'text-center'},
                {data: 'payment_status', name: 'payment_status',searchable:false,orderable : false,className : 'text-center'},
                { data: 'order_status', name: 'order_status', searchable: false,orderable : false ,className : 'text-center'},
                {data: 'employee.name', name: 'employee.name', searchable: false,orderable : false,className : 'text-center', defaultContent: '-'},
                {data: 'action', name: 'action', searchable: false, orderable : false},
            ]
    });
}
$(document).ready(function () {
    initializeDataTable();
    $('#yourButtonId').on('click', function () {
        initializeDataTable();
    });
});
$("#example1").on('click', '.data-delete', function () {
    Swal.fire({
        title: "Are you sure?",
        text: "Do you want to delete this record!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, delete it!"
        }).then((result) => {
            if (result.isConfirmed) {
                var obj = jQuery(this);
                var id = obj.attr('data-id');
                $.ajax({
                    type: "DELETE",
                    url: "{{ url('admin/order')  }}/" + id,
                    data: {
                        id: id,
                        _token: "{{ csrf_token() }}"
                    },
                    dataType: 'json',
                    beforeSend: function () {
                        $(this).attr('disabled', true);
                        $('.alert .msg-content').html('');
                        $('.alert').hide();
                    },
                    success: function (resp) {
                        if(resp.success == true){
                            oTable.ajax.reload();
                            toastr.success(resp.message);
                        }
                    },
                    error: function (e) {
                        alert('Error: ' + e);
                    }
                });
            }
        });
        
});

$(function () {    	 
    var start = moment().subtract(29, 'days');
	    var end = moment();
	    $('#reportrange').daterangepicker({
	        startDate: start,
	        endDate: end,
	        ranges: {
	           'Today': [moment(), moment()],
	           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
	           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
	           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
	           'This Month': [moment().startOf('month'), moment().endOf('month')],
	           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
	        }
	    }, 
	    function cb(start, end) {
	        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
	            $('#startDate').val(start.format('DD-MM-YYYY'));
                $('#endDate').val(end.format('DD-MM-YYYY'));
                $('#example1').DataTable().ajax.reload();
	    }
	    )
});
</script>
@endsection