@extends('admin.layout.app')

@section('content')

<style>
.status-inactive {
   
}
</style>
<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">      
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Property Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Property Details</span>
                </div>
            </div>
           <div class="d-flex my-xl-auto right-content">
                <div class="d-flex my-xl-auto right-content" style="margin-right: 15px;">
                    <div id="reportrange"  class="date_picker_range">
                        <i class="far fa-calendar-alt"></i>&nbsp;
                        <span>Date Filter</span> <b class="caret"></b>
                        <i class="fas fa-caret-down float-right"></i>
                        <input type="hidden" name="startDate" id="startDate" value="{{request()->startDate}}" />
                        <input type="hidden" name="endDate" id="endDate" value="{{request()->endDate}}" />
                    </div>
                </div>
				  <div class="pe-1 mb-xl-0">
                    <a href="{{ url('admin/customer/create') }}"><button type="button" class="btn btn-primary">Add Property</button></a>
				 </div>
            </div>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Property Details</h4>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table  key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr class="bg-dark text-white" >
                                        <th class="bg-black text-white rounded-left"><span>Sr No</span></th>
                                        <th class="text-white" ><span>Info</span></th>
                                        <th class="text-white" ><span>Create Date</span></th>
                                        <th class="text-white" ><span>Status</span></th>
                                        <th  class="text-white rounded-right">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                </tbody>
                            </table>
                        </div>
						
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Property Details</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <div id="customer_detail_append"></div>
        </div>
        <div class="modal-footer">
             <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
</div>


@endsection
@section('js')
<script>
jQuery(document).ready(function () {
    var oTable = $('#example1').DataTable({
            "responsive": true, "lengthChange": true, "autoWidth": true, "pageLength": 25,
            processing: true,
            serverSide: true,
            dom:'lBfrtip',
            ajax:{ 
                url: "{{ url('admin/property') }}",
                type: 'get',
                data: function (d) {
                    d._token = "{{ csrf_token() }}";
                    d.startDate = $('#startDate').val();
                    d.endDate = $('#endDate').val();
                    d.search = {
                        value: $('input[type="search"]').val()  
                    };
                },
                
                },
            columns: [

                {data: 'sr_no', name: 'sr_no', orderable : false, searchable: false,className : 'text-center'},
                {data: 'image_name', name: 'image_name',searchable: false,orderable : false,className : 'text-left'},
                {data: 'created_at', name: 'created_at',orderable : false,className : 'text-center', searchable: false},
                {data: 'status', name: 'status',orderable : false,className : 'text-center', searchable: false},
                {data: 'action', name: 'action', searchable: false,className : 'text-center', orderable : false},
            ]
            
    });
});

    $("#example1").on('click', '#statusToggle', function () {
        Swal.fire({
            title: "Are you sure?",
            text: "you want to Change this Property Status ?",
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, confirm it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var id = $(this).data('id');
                var currentStatus = jQuery(this).data('status');
                jQuery.ajax({
                    url: "{{ url('admin/customer') }}/" + id ,
                    type: 'PUT',
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "id": id,
                        "currentStatus": currentStatus,
                    },
                    success: function (data) {
                        if(data.success == true){
                            jQuery('#statusToggle').data('status', data.status);
                            toastr.success(data.message);
                            oTable.ajax.reload();
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });
            }else{
                oTable.ajax.reload();
            }
        });
    });

    $("#example1").on('click', '.data-delete', function () {
        var obj = jQuery(this);
        var id = obj.attr('data-id');

        if (confirm("Are you sure to Delete Data?")) {
            jQuery.ajax({
                type: "POST",
                url: "{{ url('admin/customerdelete')  }}/" + id,
                data: {
                    id: id,
                    _token: "{{ csrf_token() }}"
                },
                dataType: 'json',
                beforeSend: function () {
                    // Use the stored reference to the clicked element
                    obj.attr('disabled', true);
                    jQuery('.alert .msg-content').html('');
                    jQuery('.alert').hide();
                },
                success: function (resp) {
                    if(resp.success == true)
                    {
                        toastr.success(resp.message);
                        setTimeout(function() {
                            window.location.reload();
                        }, 1500);
                    }
                }
                
            });
        }
    });
    $("#example1").on('click', '.customerView', function () {
        var obj = jQuery(this);
        var id = obj.attr('data-id');
        jQuery.ajax({
            type: "POST",
            url: "{{ url('admin/customerView')  }}",
            data: {
                id: id,
                _token: "{{ csrf_token() }}"
            },
            dataType: 'json',
            beforeSend: function () {
                
            },
            success: function (resp) {
                if(resp.success == true)
                {
                   $('#exampleModal').modal({
                                        backdrop: 'static',
                                        keyboard: false,
                                    }).modal('show');
                   $('#customer_detail_append').html(resp.html);
                }
            }
            
        });

    });

$(function () {    	 
    var start = moment().subtract(29, 'days');
        var end = moment();
        $('#reportrange').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            }
        }, 
        function cb(start, end) {
            $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                $('#startDate').val(start.format('DD-MM-YYYY'));
                $('#endDate').val(end.format('DD-MM-YYYY'));
                $('#example1').DataTable().ajax.reload();
        }
        )
});
		
function changeStatus(newStatus, recordId) {
            // Update the status label color and text without reloading the page
            const statusSpan = document.getElementById(`status-${recordId}`);
            statusSpan.className = ''; // Clear existing classes
            
            // Set new color classes based on status
            if (newStatus === 'Pending') {
                statusSpan.classList.add('bg-warning', 'text-dark', 'rounded-pill', 'px-3', 'py-1', 'dropdown-toggle');
            } else if (newStatus === 'Active') {
                statusSpan.classList.add('bg-success', 'text-white', 'rounded-pill', 'px-3', 'py-1', 'dropdown-toggle');
            } else if (newStatus === 'Inactive') {
                statusSpan.classList.add('border', 'bg-danger', 'text-white', 'rounded-pill', 'px-3', 'py-1', 'dropdown-toggle');
            }

            // Update the displayed text
            statusSpan.textContent = newStatus;

            const dropdownMenu = statusSpan.closest('.dropdown').querySelector('.dropdown-menu');
            if (dropdownMenu) {
                dropdownMenu.classList.remove('show');
            }
            const dropdownElement = statusSpan.closest('.dropdown');
            dropdownElement.classList.remove('show');

            // Optionally remove the 'aria-expanded' attribute if needed
            statusSpan.setAttribute('aria-expanded', 'false');
}
</script>
@endsection