@extends('admin.layout.app')
@section('content')
<div class="main-content app-content">
    <div class="main-container container-fluid">
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto">Phone Number</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ @if(empty($numbers)) New   @else Edit @endif Phone Number</span>
            </div>
        </div>
    </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">@if(empty($numbers)) New   @else Edit @endif Phone Number</h4>
                        <p class="mb-2"></p>
                    </div>
                    @if(empty($numbers))
                        <form class="form-horizontal" action="{{ url('admin/phone') }}" enctype="multipart/form-data" method="post">
                    @else
                        <form class="form-horizontal" action="{{ url('admin/phone',$numbers->id) }}" enctype="multipart/form-data" method="post">
                        @method('PUT')
                    @endif	
                    {{ csrf_field() }}
                        <div class="card-body pt-0">
                            @include('admin.phonenumber.form')
                        </div>
                        <div class="card-footer">
                            @php
                                $search_type = Request::get('previous');
                            @endphp
                            <a href="{{ url('admin/' . ($search_type ?? 'phone') . '?status=' . ($numbers->status ?? 'Available')) }}" class="btn btn-secondary mb-3">Back</a>
                            @if(!empty($numbers) && $numbers->status == 'Sold')
                               
                            @else
                                <button type="submit" class="btn btn-primary float-end mb-3">Submit</button>
                            @endif
                        </div>
                    </form>
                </div>
            </div>
        </div>
	</div>
</div>

@endsection