@extends('admin.layout.app')
@section('content')
<style>
.input-group-text {
	font-size:1.4rem;
	border-radius:3px;
}
.form-control{
	color: #322a35;
	border: 1px solid #8bbef !important;
}
.select2-container--default .select2-selection--single{
    border: 1px solid #e1e5ef !important;
	border-radius: 3px !important;
}
span.select2-selection.select2-selection--single{
	height: 35px;
}
</style>
<div class="main-content app-content">
    <div class="main-container container-fluid">
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto">Numbers Status Update</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ Numbers Status Update</span>
            </div>
        </div>
    </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">Numbers Status Update</h4>
                        <p class="mb-2"></p>
                    </div>
                    <form class="form-horizontal" action="{{ url('admin/bulknumberupdate') }}" enctype="multipart/form-data" method="post">
                        {{ csrf_field() }}
                        <div class="card-body pt-0">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group {{ $errors->has('action') ? ' has-error' : '' }}">
                                        <label for="action" class="form-label text-dark">Action</label>
                                        <select class="form-control form-select js-example-basic-multiple" name="action" required="required">
                                            <option value="">Choose One</option>
                                            <option value="Update">Update</option>
                                            <option value="Delete">Delete</option>
                                        </select>
                                        @error('action')
                                            <div style="color:red">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group {{ $errors->has('number') ? ' has-error' : '' }}">
										<label class="form-label text-dark">Vanity Number</label>
                                        <textarea name="number" class="form-control" id="editor1" cols="30" rows="10" required></textarea>
                                        {{-- <input name="number" class="form-control" required> --}}
									</div>
                                    @error('number')
                                        <div style="color:red">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group {{ $errors->has('status') ? ' has-error' : '' }}">
                                        <label for="status" class="form-label text-dark">Number Status</label>
                                        <select class="form-control form-select js-example-basic-multiple" name="status" >
                                            <option value="">Choose One</option>
                                            <option value="Available">Available</option>
                                            <option value="Sold">Sold</option>
                                            <option value="sold_by_vendor">Sold By Vendor</option>
                                             <option value="Hold">Hold</option>
                                            <option value="not_available">Not Available</option>
                                            <option value="vendor_deactivated">Vendor Deactivated</option>
                                        </select>
                                        @error('status')
                                            <div style="color:red">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer ">
                            {{-- <a href="{{url('admin/phone')}}" class="btn btn-secondary mb-3">Back</a> --}}
                            <button type="submit" class="btn btn-primary float-end mb-3">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
	</div>
</div>
@endsection
@section('js')
<script>
$(document).ready(function () {
    $('.js-example-basic-multiple').select2();
});
</script>
@endsection