@extends('admin.layout.app')
@section('content')

<div class="container"> 


<div class="row">
    <div class="col-lg-12 mt-5">
        <div class="card custom-card overflow-hidden">
            <div class="card-header">
                <h3 class="card-title">About Customer</h3>
            </div>
            <div class="card-body">
                <div class="text-center">
                    <div class="text-justify">
                        <p>
                            Company Name: <strong>{{$customer->company_name??''}}</strong> <br>
                            GSTIN NO: {{$customer->gst_number??''}}<br>
                            Customer Name: {{$customer->name??''}}<br>
                            Phone: {{$customer->mobile??''}}<br>
                            Email: {{$customer->email??''}}<br>
                            Address: {{$customer->address??''}}<br>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header border-bottom-0">
                <h3 class="card-title">Enquiry Activity</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive" style="height:300px; overflow:scroll;">
                    <table class="table table-bordered border text-nowrap mb-0" id="basic-edit">
                        <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Request Number</th>
                                    <th>Email</th>
                                    <th>Mobile</th>
                                    <th>Date</th>
                                </tr>
                        </thead>
                        <tbody>
                            @php $sr = 0; @endphp
                                @foreach($enquiries as $e)
                                    @php  $sr++;  @endphp
                                    <tr>
                                        <td class="center">{{$sr}}</td>
                                        
                                            <td class="center">{{$e->first_name}}</td>
                                            
                                            <td class="center"> <!-- <a onclick="window.open('viewNumberDetails?Number=8650986504&address=ordershipping', '_blank', 'height=500, width=550, left=150, top=150,  titlebar=no, toolbar=no, addressbar=no, menubar=no, location=no, resizable=no');" href="#">-->{{$e->product_number}}</td> 
                                            
                                            <td class="center">{{$e->email}}</td>
                                                <td class="center">{{$e->mobile}}</td>
                                            <td class="center">{{$e->created_at}}</td>
                                            
                                    </tr>
                                @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header border-bottom-0">
                <h3 class="card-title">Order Activity</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive" style="height:300px; overflow:scroll;">
                    <table class="table table-bordered border text-nowrap mb-0" id="basic-edit">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Order Id</th>
                                    <th>Comment By</th>
                                    <th>Comment</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php 
                                    $sr = 0;
                                    $orderactivity = App\Models\OrderActivity::with('employee')->whereIn('order_activity.order_id',$order_id)->select('order_activity.*')->get();    
                                @endphp       
                                @if($orderactivity) 
                                    @foreach($orderactivity as $c)  
                                        @php  
                                            $sr++;  
                                            $order_id = App\Models\Order::find($c->order_id);
                                        @endphp        
                                        <tr>
                                            <td class="center">{{$sr}}</td>
                                            <td class="center">{{$order_id->order_number}}</td>
                                            <td class="center">{{$c->employee->name??""}}</td>
                                            <td class="center">{!!$c->remark !!}</td>
                                            <td class="center">{{$c->created_at}}</td>
                                        </tr>
                                    @endforeach
                                @endif
                                
                            </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="">
            <div class="card">
                <div class="card-header border-bottom-0">
                    <h3 class="card-title">Add a Comment</h3>
                </div>
                <div class="card-body">
                    <div class="mt-2">
                        <form  action="{{ url('admin/orderactivity') }}"  method="post" name="form">
                            <!-- row -->
                            {{ csrf_field() }}           
                            <input type="hidden" name="order_id" value="{{$order->id}}">
                            <div class="form-group">
                                <label class="form-label">Assign TO </label>
                                <select name="employee_id" class="form-control form-select js-example-basic-multiple" data-bs-placeholder="Assign TO" required="required">
                                    <option value="">------Select-----</option>
                                    @php  
                                        $admin = App\Models\Admin::where('Is_employee',1)->get();  
                                    @endphp
                                    @foreach($admin as $a)
                                        <option value="{{$a->id}}" {{!empty($last_order_activity) && $last_order_activity->employee_id == $a->id ? 'selected' : ''}}>{{$a->name}}</option>
                                    @endforeach
                                        
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="form-label">Status</label>
                                <select name="status"  class="form-control form-select js-example-basic-multiple" data-bs-placeholder="Status" required="required">
                                    <option value="">------Select-----</option>
                                    <option value="new_order" {{!empty($last_order_activity) && $last_order_activity->status == 'new_order' ? 'selected' : ''}}>New</option>
                                    <option value="call_back" {{!empty($last_order_activity) && $last_order_activity->status == 'call_back' ? 'selected' : ''}}>Call Back</option>
                                    <option value="not_contacted" {{!empty($last_order_activity) && $last_order_activity->status == 'not_contacted' ? 'selected' : ''}}>Not Contacted</option>
                                    <option value="inprocess" {{!empty($last_order_activity) && $last_order_activity->status == 'inprocess' ? 'selected' : ''}}>Inprocess</option>
                                    <option value="Follow up" {{!empty($last_order_activity) && $last_order_activity->status == 'Follow up' ? 'selected' : ''}}>Follow up</option>
                                    <option value="on_hold" {{!empty($last_order_activity) && $last_order_activity->status == 'on_hold' ? 'selected' : ''}}>ON Hold</option>
                                    <option value="closed_won" {{!empty($last_order_activity) && $last_order_activity->status == 'closed_won' ? 'selected' : ''}}>Convert to Order</option>
                                    <option value="closed_lost" {{!empty($last_order_activity) && $last_order_activity->status == 'closed_lost' ? 'selected' : ''}}>Closed Lost</option>
                                    <option value="language_barrier" {{!empty($last_order_activity) && $last_order_activity->status == 'language_barrier' ? 'selected' : ''}}>Language Barrier</option>
                                    <option value="duplicate" {{!empty($last_order_activity) && $last_order_activity->status == 'duplicate' ? 'selected' : ''}}>Duplicate</option>
                                    <option value="test" {{!empty($last_order_activity) && $last_order_activity->status == 'test' ? 'selected' : ''}}>Test</option>
                                    <option value="cancelled" {{!empty($last_order_activity) && $last_order_activity->status == 'cancelled' ? 'selected' : ''}}>Cancelled</option>
                                    <option value="wrong_data" {{!empty($last_order_activity) && $last_order_activity->status == 'wrong_data' ? 'selected' : ''}}>Wrong Data</option>
                                    <option value="to_be_refund" {{ !empty($last_order_activity) && $last_order_activity->status == 'to_be_refund' ? 'selected' : ''}}>To Be Refund</option>
                                    <option value="refund" {{!empty($last_order_activity) && $last_order_activity->status == 'refund' ? 'selected' : ''}}>Refund</option>
                                    <option value="UPC_Error" {{!empty($last_order_activity) && $last_order_activity->status == 'UPC_Error' ? 'selected' : ''}}>UPC Error</option>
                                    <option value="transfer" {{!empty($last_order_activity) && $last_order_activity->status == 'transfer' ? 'selected' : ''}}>Transfer Order</option>
                                    <option value="teleduce" {{!empty($last_order_activity) && $last_order_activity->status == 'teleduce' ? 'selected' : ''}}>Teleduce</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                {{-- <textarea class="summernote" id="summernote" name="remark" rows="5" cols="50" placeholder="Message" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;" required></textarea> --}}
                                <textarea class="summernote form-control" id="summernote" name="remark" rows="5" placeholder="Message"></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary float-end">Submit</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>

@endsection
@section('js')
<script>
$(document).ready(function() {
    $('.js-example-basic-multiple').select2();
});

</script>
@endsection