@extends('admin.layout.app')
@section('content')
<style>
	.input-group-text {
		font-size: 1.4rem;
		border-radius: 3px;
	}

	.form-control {
		color: #322a35;
	}
</style>
<div class="main-content app-content">
	<div class="main-container container-fluid">
		<div class="breadcrumb-header justify-content-between">
			<div class="my-auto">
				<div class="d-flex">
					<h4 class="content-title mb-0 my-auto">Order</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/
						Payment</span>
				</div>
			</div>
		</div>
		<div class="row row-sm">
			<div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
				<div class="card  box-shadow-0">
					<div class="card-header">
						<h4 class="card-title mb-1">Paymenrt</h4>
						<p class="mb-2"></p>
					</div>

					<form class="form-horizontal" action="{{ url('admin/paymentstore') }}" enctype="multipart/form-data"
						method="post">

						{{ csrf_field() }}
						<div class="card-body pt-0">
							<div class="row">
								<div class="col-lg-12 col-md-12 col-md-12">
									<div class="card blog-edit">
										<div class="card-body">


											<input type="hidden" name="order_id" value="{{$order->id}}">

											<div class="form-group">
												<label class="form-label">Order No.</label>
												<input type="text" class="form-control" name="order_number"
													placeholder="Order No." title="Please enter valid Amount" readonly
													value="{{$order->order_number}}">


												@error('order_no')
												<div style="color:red">{{ $message }}</div>
												@enderror
											</div>

											<div class="control-group form-group">
												<label class="form-label">Payment type</label>
												<select name="payment_type" class="form-control form-select select2"
													data-bs-placeholder="Payment Type" required="required">
													<option value="">------Select-----</option>
													<option value="New" selected>New</option>
													<option value="Refund">Refund</option>
												</select>
												@error('payment_type')
												<div style="color:red">{{ $message }}</div>
												@enderror
											</div><!-- input-group -->


											<div class="form-group">
												<label class="form-label text-dark">Total Amount</label>
												<input type="text" class="form-control" name="amount" value="{{$order->order_total}}" placeholder="Total Amount" title="Please enter valid Amount" required="required">
												@error('amount')
												<div style="color:red">{{ $message }}</div>
												@enderror
											</div>

											<div class="form-group">
												<label class="form-label">Mode Of Payment</label>
												<select class="form-control form-select select2" name="payment_mode"
													data-bs-placeholder="Mode Of Payment" required="required">
													<option value="">------Select-----</option>
													<option value="Online Phone Pay Gateway">Online Phone Pay Gateway</option>
													<option value="Bank Transfer" {{!empty($vendorpayment)?$vendorpayment->payment_mode == 'BankTransfer'?'selected':'':''}}>Bank Transfer</option>
													<option value="Cash">Cash</option>
													<option value="Paytm">Paytm</option>
													<option value="Paytm QR">Paytm QR</option>
													<option value="Phone Pay">Phone Pay</option>
													<option value="Online Razorpay Gateway">Online Razorpay Gateway</option>
													{{-- <option value="BHIM UPI">BHIM UPI</option> --}}
													{{-- <option value="JD Pay">JD Pay</option> --}}
													<option value="G Pay">G Pay</option>
												</select>

												@error('payment_mode')
												<div style="color:red">{{ $message }}</div>
												@enderror
											</div>


											<div class="form-group">
												<label class="form-label text-dark">TXN ID / Cheque Number</label>
												<input type="text" class="form-control" name="txn_id"
													placeholder="TXN ID / Cheque Number"  value="">
												@error('txn_id')
												<div style="color:red">{{ $message }}</div>
												@enderror
											</div>

											<div class="form-group">
												<label class="form-label">Approval SMS</label>
												<select name="approval_sms" class="form-control form-select select2"
													data-bs-placeholder="Approval SMS" required="required">
													<option value="NO">NO</option>
													<option value="YES">YES</option>
												</select>
												@error('approval_sms')
												<div style="color:red">{{ $message }}</div>
												@enderror
											</div>

											<div class="form-group">
												<label class="form-label text-dark">Payment Remarks</label>
												<textarea class="summernote" id="summernote" name="remarks" rows="5"
													cols="50" placeholder="payment Remarks" required="required"
													style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"></textarea>

											</div>

											<div class="form-group">
												<label class="form-label text-dark">Upload Image</label>
												<input type="file" name="image" />
												@error('image')
												<div style="color:red">{{ $message }}</div>
												@enderror
											</div>

										</div>

									</div>
								</div>
							</div>


						</div>
						<div class="card-footer ">
							<a href="{{url()->previous()}}" class="btn btn-secondary mb-3">Back</a>
							<button type="submit" class="btn btn-primary float-end mb-3">Submit</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>

@endsection
@section('js')
<script>
	/*  
  $(function () {
	$('#payment_date').bootstrapdatepicker({
		autoclose: true,
		format: "dd-mm-yyyy",
		viewMode: "date",
	});

})  */
 
  
  jQuery(document).ready(function () {
       
        jQuery('.image-input').on('change', function () {
            
            var file = this.files[0];
             var previewId = jQuery(this).data('preview');
             console.log(previewId);
          
            if (file) {
               
                var reader = new FileReader();

              
                reader.onload = function (e) {
                   
                    jQuery('#' + previewId).attr('src', e.target.result);
                };

                
                reader.readAsDataURL(file);
            } else {
               
                jQuery('#' + previewId).attr('src', ''); 
            }
        });
    });
</script>
@endsection