<style>
  .input-group-text {
    font-size: 1.4rem;
    border-radius: 3px;
  }

  .form-control {
    color: #322a35;
    border: 1px solid #8bbef !important;
  }

  .select2-container--default .select2-selection--single {
    border: 1px solid #e1e5ef !important;
    border-radius: 3px !important;
  }

  span.select2-selection.select2-selection--single {
    height: 35px;
  }

  .select2 {
    width: 100% !important;
  }
  .select2-container--default .select2-selection--multiple {
    border: 1px solid #e1e5ef !important;
  }
</style>
<div class="row">
  <div class="col-md-6">
    <div class="form-group {{ $errors->has('customer_id') ? ' has-error' : '' }}">
      <label for="customer_id" class="form-label text-dark">Customer</label>
      <select class="form-control form-select customer_id" name="customer_id" id="customer_dropdown"
        required="required">
        <option value="">Choose One</option>
      </select>
      
      @error('customer_id')
        <div style="color:red">{{ $message }}</div>
      @enderror
    </div>
    <button type="button" class="btn btn-primary" onclick="customermodalopen();" style="margin-bottom: 14px;">
      Add New Customer
    </button>
  </div>
  <div class="col-md-6">
    <div
      class="form-group {{ $errors->has('assign_to') ? ' has-error' : '' }}">
      <label for="assign_to" class="form-label text-dark">Assign To</label>
      <select class="form-control form-select js-example-basic-multiple" name="assign_to" required="required">
        <option value="">Choose One</option>
        @foreach($employees as $employee)
          <option value="{{ $employee->id }}">{{ $employee->name }} {{ $employee->email }}</option>
        @endforeach
      </select>
      @error('assign_to')
        <div style="color:red">{{ $message }}</div>
      @enderror
    </div>
  </div>
  <div class="col-md-6">
    <div
      class="control-group form-group {{ $errors->has('activation_date') ? ' has-error' : '' }}">
      <label class="form-label">Order Date</label>
      <div class="input-group">
        <div class="input-group-text">
          <i class="typcn typcn-calendar-outline tx-24 lh--9 op-6"></i>
        </div>
        <input class="form-control datepicker" name="activation_date" id="activation_date" autocomplete="off"
          data-format="dd-MM-yyyy" placeholder="dd-MM-yyyy" type="text" required>
      </div>
      @error('order_date')
        <div style="color:red">{{ $message }}</div>
      @enderror
    </div>
  </div>
  <div class="col-md-6">
    <div
      class="form-group {{ $errors->has('numbers') ? ' has-error' : '' }}">
      <label for="numbers" class="form-label text-dark">Numbers</label>
      {{-- <input type="text" class="form-control" id="numbers" placeholder="Numbers" name="numbers" value="{{ !empty($order)?$order->numbers:'' }}"
      required> --}}
      <select class="form-control form-select numbers" name="numbers[]" id="numbers" required="required" multiple>
        <option value="">Choose One</option>
      </select>
      @error('numbers')
        <div style="color:red">{{ $message }}</div>
      @enderror
    </div>
  </div>
  <div class="col-md-6">
    <div
      class="form-group {{ $errors->has('gst_status') ? ' has-error' : '' }}">
      <label for="gst_status" class="form-label text-dark">GST</label>
      <select class="form-control form-select " name="gst_status" required="required">
        <option value="No" selected>NO</option>
        <option value="Yes">YES</option>
      </select>
      @error('gst_status')
        <div style="color:red">{{ $message }}</div>
      @enderror
    </div>
  </div>
  <div class="col-md-6">
    <div
      class="form-group {{ $errors->has('email_to_customer') ? ' has-error' : '' }}">
      <label for="email_to_customer" class="form-label text-dark">Email To Customer</label>
      <select class="form-control form-select " name="email_to_customer" required="required">
        <option value="NO">NO</option>
        <option value="YES">YES</option>
      </select>
      @error('email_to_customer')
        <div style="color:red">{{ $message }}</div>
      @enderror
    </div>
  </div>
  <div class="col-md-6">
    <div
      class="form-group {{ $errors->has('sms_to_customer') ? ' has-error' : '' }}">
      <label for="sms_to_customer" class="form-label text-dark">SMS To Customer </label>
      <select class="form-control form-select " name="sms_to_customer" required="required">
        <option value="NO">NO</option>
        <option value="YES">YES</option>
      </select>
      @error('sms_to_customer')
        <div style="color:red">{{ $message }}</div>
      @enderror
    </div>
  </div>
</div>

@section('js')
<script>
  // toggleCorporateFields();
function toggleCorporateFields() {
    var customerType = $('#customer_type').val();
    if (customerType === 'Corporate') {
        $('#company_name').closest('.form-group').show();
        $('#gst_number').closest('.form-group').show();
        $('#company_name').prop('disabled', false);
        $('#gst_number').prop('disabled', false);
        $('#company_name').attr('required', true);
        $('#gst_number').attr('required', true);
    } else {
        $('#company_name').closest('.form-group').hide();
        $('#gst_number').closest('.form-group').hide();
        $('#company_name').prop('disabled', true);
        $('#gst_number').prop('disabled', true);
        $('#company_name').attr('required', false);
        $('#gst_number').attr('required', false);
    }
}

function customermodalopen(){
  toggleCorporateFields();
  $('#exampleModal').modal({
                            backdrop: 'static',
                            keyboard: false,
                        }).modal('show');
}
  function isValidEmail(email) {
    // Regular expression for email validation
    var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return emailRegex.test(email);
}
  function customerCheck() {
    $('.form-control').removeClass('is-invalid');
    $('.text-danger').text('');
    var isValid = true;

    var name = $('#inputName').val().trim();
    var mobile = $('#mobile').val().trim();
    var email = $('#email').val().trim();
    var customer_type = $('#customer_type').val().trim();
    var pincode = $('#pincode').val().trim();
    var address = $('#address').val().trim();
    var state = $('#state').val().trim();
    var company_name = $('#company_name').val().trim();
    var gst_number = $('#gst_number').val().trim();

    if (name === '') {
        $('#name_error').text('Please enter customer name');
        isValid = false;
    }
    if (mobile === '') {
        $('#mobile_error').text('Please enter your mobile');
        isValid = false;
    }
    if (email === '') {
        $('#email_error').text('Please enter your email');
        isValid = false;
    }else if (!isValidEmail(email)) {
        $('#email_error').text('Invalid email format');
        isValid = false;
    }
    if (customer_type === '') {
        $('#customer_type_error').text('Please enter your customer type');
        isValid = false;
    }
    if (customer_type == 'Corporate') {
      if (company_name === '') {
          $('#company_name_error').text('Please enter company name');
          isValid = false;
      }
      if (gst_number === '') {
          $('#gst_number_error').text('Please enter GST number');
          isValid = false;
      }
    }
    if (pincode === '') {
        $('#pincode_error').text('Please enter your pincode');
        isValid = false;
    }
    if (address === '') {
        $('#address_error').text('Please enter your address');
        isValid = false;
    }
    if (state === '') {
        $('#state_error').text('Please enter your state');
        isValid = false;
    }
    if (isValid) {
      var formdata = $('#customerform').serialize();
      $.ajax({
        url: "{{ url('admin/customerCheck') }}",
        type: 'post',
        data: {
          "_token": "{{ csrf_token() }}",
          formdata: formdata,
        },
        success: function (data) {
          if (data.success == true) {
            $('#exampleModal').modal('hide');
            $('#customer_dropdown').append(data.customer);
            toastr.success(data.message);
            $('#customerform')[0].reset();
          } else {
            $('#customer_error').html(data.message)
            toastr.error(data.message);
          }
        },
        error: function (xhr, status, error) {
          console.error(xhr.responseText);
        }
      })
    }
  }
  $(function () {
    $('.datepicker').bootstrapdatepicker({
      autoclose: true,
      format: "dd-mm-yyyy",
      viewMode: "date",
      todayHighlight: true,
    });
  })
  $(document).ready(function () {
    $('.js-example-basic-multiple').select2();

    $('.customer_id').select2({
      ajax: {
        url: '{{ url('admin/getcustomer_search') }}',
        dataType: 'json',
        data: function (params) {
          return {
            q: $.trim(params.term)
          };
        },
        processResults: function (data) {
          return {
            results: data
          };
        },
        cache: true
      }
    });

    $('.numbers').select2({
      ajax: {
        url: '{{ url('admin/numberssearch') }}',
        dataType: 'json',
        data: function (params) {
          return {
            q: $.trim(params.term)
          };
        },
        processResults: function (data) {
          return {
            results: data
          };
        },
        cache: true
      }
    });


  });
</script>

@endsection