@extends('admin.layout.app')
@section('content')
<style>
    span.coupon_color{
        color: #00b9ff;
    }
    aside{
        display: none;
    }
</style>
<div class="m-2">
    <div>
        <h6>Customer Name :- {{$order->name}} </h6>
    </div>
    <div>
        <h6>Customer Number :- {{$order->mobile_no}}</h6>
    </div>
    <div>
        <h6>Coupon Code :- <span class="coupon_color">{{$order->coupon_code}}</span></h6>
    </div>
    <div>
        <h6>Coupon Discription :- <span class="coupon_color">{{$order->coupon_discription}}</span></h6>
    </div>
    <br>
    <div class="row">
        <table class="table table-hover mt-2s">
            <thead>

                <th>Order No</th>
                <th>Product ID</th>
                <th>Product Name</th>
                <th>Currnet Status</th>
                <th>Rate</th>
                <th>Discount %</th>
                {{-- <th>Discount Rate</th> --}}
                <th>UPC NO</th>
                <th>Status</th>
                <th></th>

            </thead>
    
            <tbody>     
                @foreach($orderdetail as $or)
                <tr>    
                    <td>{{$or->order_number}}</td>      
                    <td>{{$or->product_id}}</td>
                    <td><a onclick="window.open('<?php echo url('admin/phone/'.$or->product_id); ?>', '_blank', 'height=500,width=800,left=150,top=150,titlebar=no,toolbar=no,addressbar=no,menubar=no,location=no,resizable=no');" href="#">{{$or->product_name}}</a></td>
                    @php $number = App\Models\Phonenumber::where('id',$or->product_id)->first();  @endphp
                    <td>{{$number->number_status??''}}</td>
                    <td>{{$or->number_rate}}</td>
                    <td>{{$or->discount}}</td>
                    {{-- <td>{{$or->discount_rate}}</td> --}}
                    <td><a onclick="window.open('<?php echo url('admin/order/'.$or->id.'/upcedit'); ?>', '_blank', 'height=500,width=800,left=150,top=150,titlebar=no,toolbar=no,addressbar=no,menubar=no,location=no,resizable=no');" href="#">Upc No</a></td>
                    <td>
                        <select style="width:200px" id="order_status_{{$or->id}}" name="processstatus"  class=" form-control js-example-basic-multiple">
                            <option value="" selected="">Order Placed</option>
                            <option value="UPC In Process" {{ $or->status=='UPC In Process'?'selected':'' }}>UPC In Process</option>
                            <option value="UPC Delivered" {{ $or->status=='UPC Delivered'?'selected':'' }}>UPC Delivered</option>
                            <option value="Activation In Process" {{ $or->status=='Activation In Process'?'selected':'' }}>Activation In Process</option>
                            <option value="Activated" {{ $or->status=='Activated'?'selected':'' }}>Activated</option>
                            <option value="Not Contacted" {{ $or->status=='Not Contacted'?'selected':'' }}>Not Contacted</option>
                            <option value="To Be Refund" {{ $or->status=='To Be Refund'?'selected':'' }}>To Be Refund</option>
                            <option value="Refund" {{ $or->status=='Refund'?'selected':'' }}>Refund</option>
                            <option value="Test" {{ $or->status=='Test'?'selected':'' }}>Test</option>
                            <option value="Cancelled"{{ $or->status=='Cancelled'?'selected':'' }}>Cancelled</option>
                          </select>
                    </td>
                    <td><button class="btn btn-info"  onclick="savestatus({{$or->id}})"> Update Status</button></td>  

                </tr>


                @endforeach
            </tbody>
    
        </table>
    </div>
</div>


@endsection

@section('js')


<script>
$(document).ready(function () {
    $('.js-example-basic-multiple').select2();
    $('.main-header').hide();
});
    function savestatus(id) {
        var status = $('#order_status_'+id).val();
        $.ajax({
            type: "POST",
            url: "{{ url('admin/update_order_detail_status')  }}",
            data: {
                id: id,
                status: status,
                _token: "{{ csrf_token() }}"
            },
            beforeSend: function () {
            
            },
            success: function (resp) {
                    toastr.success(resp);
            
            },
            error: function (e) {
                alert('Error: ' + e);
            }
        });
    }

</script>


@endsection