<style>
.input-group-text { font-size:1.4rem; border-radius:3px; }
.form-control { color: #322a35; }
</style>

<div class="row">

    {{-- Title --}}
    <div class="col-md-8 offset-md-2">
        <div class="form-group {{ $errors->has('title') ? 'has-error' : '' }}">
            <label for="title" class="form-label text-dark">Title <span class="text-danger">*</span></label>
            <textarea name="title" id="title" class="form-control" rows="3" placeholder="Enter title" required>{{ old('title', $record->title ?? '') }}</textarea>
            @error('title')
                <div style="color:red">{{ $message }}</div>
            @enderror
        </div>
    </div>

    {{-- Description --}}
    <div class="col-md-8 offset-md-2">
        <div class="form-group {{ $errors->has('description') ? 'has-error' : '' }}">
            <label for="description" class="form-label text-dark">Description <span class="text-danger">*</span></label>
            <textarea name="description" id="description" class="form-control" rows="5" placeholder="Enter description" required>{{ old('description', $record->description ?? '') }}</textarea>
            @error('description')
                <div style="color:red">{{ $message }}</div>
            @enderror
        </div>
    </div>

	<div class="col-md-5 offset-md-2">
        <div class="form-group {{ $errors->has('start_date') ? 'has-error' : '' }}">
            <label for="start_date" class="form-label text-dark">
                Start Date <span class="text-danger">*</span>
            </label>
            <input type="text" name="start_date" class="form-control datepicker" 
           value="{{ old('start_date', $record->start_date ?? '') }}" 
           placeholder="Nov 3" required>
            @error('start_date')
                <div style="color:red; font-size:13px; margin-top:5px;">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <!-- End Date -->
    <div class="col-md-3">
        <div class="form-group {{ $errors->has('end_date') ? 'has-error' : '' }}">
            <label for="end_date" class="form-label text-dark">
                End Date
            </label>
            <input type="text" name="end_date" class="form-control datepicker" value="{{ old('end_date', $record->end_date ?? '') }}" placeholder="Nov 9">
            @error('end_date')
                <div style="color:red; font-size:13px; margin-top:5px;">{{ $message }}</div>
            @enderror
        </div>
    </div>

</div>

<script>
    var hasRecord = @json(!empty($record));
</script>

@section('js')
<script>
jQuery(function($){
    'use strict';
    $(document).ready(function() {
        $('#title').summernote({
            placeholder: 'Enter title',
            height: 100
        });
        $('#description').summernote({
            placeholder: 'Enter description',
            height: 200
        });

        $('.datepicker').datepicker({
            dateFormat: 'M d',
            showButtonPanel: true
        });

    });
});
</script>
@endsection