{{-- resources/views/admin/forecast/create_edit.blade.php --}}
@extends('admin.layout.app')

@section('content')
<div class="main-content app-content">
    <div class="main-container container-fluid">

        <!-- Breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <h4 class="content-title mb-0 my-auto">Forecast</h4>
                <span class="text-muted mt-1 tx-13 ms-2 mb-0">
                    / {{ $record ? 'Edit' : 'New' }} Forecast
                </span>
            </div>
        </div>

        <!-- Card -->
        <div class="row row-sm">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $record ? 'Edit' : 'New' }} Forecast</h4>
                    </div>

                    <form action="{{ $record ? url('admin/forecast/' . $record->id . '/update') : url('admin/forecast/store') }}"
                        method="POST"
                        enctype="multipart/form-data"
                        class="ajax_submit">

                        @csrf

                        <div class="card-body">
                            @include('admin.forecast.form')
                        </div>

                        <div class="card-footer">
                            <a href="{{ url('admin/forecast') }}" class="btn btn-secondary">Back</a>
                            <button type="submit" class="btn btn-primary float-end">
                                {{ $record ? 'Update' : 'Save' }} Forecast
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
jQuery(function($) {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $('.ajax_submit').on('submit', function(e) {
        e.preventDefault();
        let form = $(this);
        let btn = form.find('button[type="submit"]');
        let btnText = btn.text();

        btn.prop('disabled', true).text('Saving...');

        $.ajax({
            url: form.attr('action'),
            type: 'POST',
            data: new FormData(this),
            processData: false,
            contentType: false,
            success: function(res) {
                if (res.success) {
                    alert(res.message);
                    window.location.href = res.redirect;
                } else {
                    alert(res.message || 'Failed!');
                }
            },
            error: function(xhr) {
                let errors = xhr.responseJSON?.errors;
                if (errors) {
                    alert(Object.values(errors).flat().join('\n'));
                } else {
                    alert('Server error. Check console.');
                    console.log(xhr);
                }
            },
            complete: function() {
                btn.prop('disabled', false).text(btnText);
            }
        });
    });
});
</script>
@endsection