@extends('admin.layout.app')
@section('content')
<div class="main-content app-content">
    <div class="main-container container-fluid">
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto">Customer Export</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ Customer Export</span>
            </div>
        </div>
        {{-- <div class="d-flex my-xl-auto right-content">
            <div class="d-flex my-xl-auto right-content" style="margin-right: 15px;">
                <div id="reportrange"  class="date_picker_range">
                    <i class="far fa-calendar-alt"></i>&nbsp;
                    <span>Date Filter</span> <b class="caret"></b>
                    <i class="fas fa-caret-down float-right"></i>
                   
                </div>
            </div>
        </div> --}}
    </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">Customer Export</h4>
                        <p class="mb-2"></p>
                    </div>
                    <form class="form-horizontal" action="{{url('admin/customerExpert')}}" id="myForm" enctype="multipart/form-data" method="post">
                        {{ csrf_field() }}
                        <input type="hidden" name="startDate" id="startDate" value="" />
                        <input type="hidden" name="endDate" id="endDate" value="" />
                        <div class="card-body pt-0">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group ">
                                        <label for="customer_id" class="form-label text-dark">Customer</label>
                                        <select class="form-control form-select customer_id" name="customer_id" id="customer_id" >
                                            <option value="">Choose One</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group {{ $errors->has('state') ? ' has-error' : '' }}">
                                        <label for="name" class="form-label text-dark">State</label>
                                        <select class="form-control form-select js-example-basic-multiple" name="state">
                                            <option value="">Choose One</option>
                                            <option value="Andhra Pradesh" >Andhra Pradesh</option>
                                            <option value="Arunachal Pradesh" >Arunachal Pradesh</option>
                                            <option value="Assam">Assam</option>
                                            <option value="Bihar">Bihar</option>
                                            <option value="Chhattisgarh">Chhattisgarh</option>
                                            <option value="delhi">Delhi</option>
                                            <option value="Goa">Goa</option>
                                            <option value="Gujarat">Gujarat</option>
                                            <option value="Haryana" >Haryana</option>
                                            <option value="Himachal Pradesh"  >Himachal Pradesh</option>
                                            <option value="Jammu and Kashmir" >Jammu and Kashmir</option>
                                            <option value="Jharkhand"  >Jharkhand</option>
                                            <option value="Karnataka"  >Karnataka</option>
                                            <option value="Kerala" >Kerala</option>
                                            <option value="Madhya Pradesh" >Madhya Pradesh</option>
                                            <option value="Maharashtra"  >Maharashtra</option>
                                            <option value="Manipur" >Manipur</option>
                                            <option value="Meghalaya">Meghalaya</option>
                                            <option value="Mizoram" >Mizoram</option>
                                            <option value="Nagaland" >Nagaland</option>
                                            <option value="Odisha">Odisha</option>
                                            <option value="Punjab">Punjab</option>
                                            <option value="Rajasthan">Rajasthan</option>
                                            <option value="Sikkim" >Sikkim</option>
                                            <option value="Tamil Nadu">Tamil Nadu</option>
                                            <option value="Telangana" >Telangana</option>
                                            <option value="Tripura" >Tripura</option>
                                            <option value="Uttar Pradesh">Uttar Pradesh</option>
                                            <option value="Uttarakhand" >Uttarakhand</option>
                                            <option value="West Bengal" >West Bengal</option>
                                        </select>
                                        @error('state')
                                            <div style="color:red">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="control-group form-group ">
                                        <div class="form-group">
                                            <label class="form-label">Status</label>
                                            <select name="status" id="status"  class="form-control form-select js-example-basic-multiple" data-bs-placeholder="Status" >
                                                <option value="">Choose One</option>
                                                <option value="ALL" >ALL</option>
                                                <option value="Active" >Active</option>
                                                <option value="Deactive" >Deactive</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer ">
                            <button type="submit" class="btn btn-primary float-end mb-3" id="submit">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
	</div>
</div>
@endsection
@section('js')
<script>
    $(document).ready(function () {
    $('.js-example-basic-multiple').select2();
    function initSelect2() {
        $('.customer_id').select2({
            placeholder: "Select a customer",
            allowClear: true,
            ajax: {
                url: "{{ url('admin/getcustomer_search') }}",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: $.trim(params.term) // search term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });
        var defaultOption = new Option("Select a customer", "", true, true);
        $('.customer_id').append(defaultOption).trigger('change');
    }

    initSelect2();
    $('.customer_id').on('select2:clear', function (e) {
        $(this).empty();
        initSelect2();
    });
  
});
$(function () {    	 
    var start = moment().subtract(29, 'days');
	    var end = moment();
	    $('#reportrange').daterangepicker({
	        startDate: start,
	        endDate: end,
	        ranges: {
	           'Today': [moment(), moment()],
	           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
	           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
	           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
	           'This Month': [moment().startOf('month'), moment().endOf('month')],
	           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
	        }
	    }, 
	    function cb(start, end) {
	        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
	            $('#startDate').val(start.format('DD-MM-YYYY'));
                $('#endDate').val(end.format('DD-MM-YYYY'));
                // $('#example1').DataTable().ajax.reload();
	    }
	    )
});
</script>
@endsection