<style>
.input-group-text {
	font-size:1.4rem;
	border-radius:3px;
}
.form-control{
	color: #322a35;
}
</style>
    <div class="row">
        <div class="col-md-12">
            <div class="form-group {{ $errors->has('name') ? ' has-error' : '' }}">
                <label for="name" class="form-label text-dark">Category Name<span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="inputName" placeholder="Enter Category Name" name="name" value="{{!empty($category)?$category->name:''}}">
                @error('name')
                <div style="color:red">{{ $message }}</div>
                @enderror
            </div>
        </div>
       
       <div class="col-md-6"> 
            <div class="form-group {{ $errors->has('image') ? ' has-error' : '' }}">
                <label for="image" class="form-label text-dark">Upload Image<span class="text-danger">{{  !empty($category)?'':'*'  }}</span></label>
                <input type="file" class="form-control image-input" id="inputEmail3" data-preview="image" placeholder="image" name="image">
                @error('image')
                    <div style="color:red">{{ $message }}</div>
                @enderror
            </div>
        </div> 
         <div class="col-md-6">
            <img class="form-group  image-preview" id="image" src="{{$category?$category->image_url:url('public/assets/admin/images/not-available (1).jpg')}}" style="width:150px;">
        </div> 
        <div class="col-md-6">
            <div class="form-group {{ $errors->has('multi_cat_image') ? ' has-error' : '' }}">
                <label for="multi_cat_image" class="form-label text-dark">Upload Multiple Images<span class="text-danger"></span></label>
                <input type="file" class="form-control" id="multi_cat_image" placeholder="multiple images" name="multi_cat_image[]" multiple>
                @error('multi_cat_image')
                    <div style="color:red">{{ $message }}</div>
                @enderror
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
            @if(!empty($category))
                @foreach($category->categoryImages as $image)
                    <button type="button" class="btn-close category-image-delete" aria-label="Close"  data-id="{{$image->id}}"></button>
                    <img class="form-group  image-preview" id="" src="{{$image->image_url}}" style="width:150px;">
                @endforeach
            @endif
            </div>
        </div>
    </div>
    {{-- <div class="row">
        <div class="col-md-2">
            <div class="form-group mb-0 mt-3 justify-content-end">
                <div>
                    <button type="submit" class="btn btn-primary">Submit</button>
                    <button type="button" class="btn btn-secondary ms-4">Cancel</button>
                </div>

            </div>
        </div>
    </div> --}}
   

@section('js')
<script>

  
  jQuery(document).ready(function () {
       
        jQuery('.image-input').on('change', function () {
            
            var file = this.files[0];
             var previewId = jQuery(this).data('preview');
             console.log(previewId);
          
            if (file) {
               
                var reader = new FileReader();

              
                reader.onload = function (e) {
                   
                    jQuery('#' + previewId).attr('src', e.target.result);
                };

                
                reader.readAsDataURL(file);
            } else {
               
                jQuery('#' + previewId).attr('src', ''); 
            }
        });
    });

    $("body").on("click", ".category-image-delete", function () {
        console.log('category-image-delete');
        Swal.fire({
            title: "Are you sure?",
            text: "Do you want to delete this image?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var obj = jQuery(this);
                var id = obj.attr('data-id');
                    jQuery.ajax({
                        type: "POST",
                        url: "{{ url('admin/category-image-delete')  }}",
                        data: {
                            "id": id,
                            _token: "{{ csrf_token() }}"
                        },
                        dataType: 'json',
                        success: function (resp) {
                            if(resp.success == true)
                            {
                                window.location.reload();
                                toastr.success(resp.message);
                            }
                        }
                    });
            }else{
                
            }
        });
    });
  
  </script>

@endsection