@extends('admin.layout.app')

@section('content')

<div class="main-content app-content">

    <div class="main-container container-fluid">

        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Brochure Details</h4>
                    <span class="text-muted mt-1 tx-13 ms-2 mb-0">/ View Brochures</span>
                </div>
            </div>

            <!-- <div class="d-flex my-xl-auto right-content">
                <div class="pe-1 mb-xl-0">
                    <a href="{{ url('admin/brochure/create') }}">
                        <button type="button" class="btn btn-primary">Add Brochure</button>
                    </a>
                </div>
            </div> -->
        </div>

        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title mg-b-0">Brochure TABLE</h4>
                    </div>

                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered" id="brochureDataTable">
                                <thead>
                                    <tr>
                                        <th>PDF</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach($result as $r)
                                    <tr>
                                        <td>
                                            <a href="{{ asset($r->pdf) }}" target="_blank" class="btn btn-outline-primary btn-sm">
                                                View PDF
                                            </a>
                                        </td>

                                        <td>
                                            <div class="form-check form-switch" style="padding-left:2.25rem;">
                                                <input class="form-check-input brochureStatusToggle" type="checkbox" role="switch" data-id="{{ $r->id }}" data-status="{{ $r->status }}"{{ $r->status == 'Active' ? 'checked' : '' }}>
                                            </div>
                                        </td>

                                        <td>
                                            <a href="{{ url('admin/brochure/'.$r->id.'/edit') }}"
                                               class="btn btn-sm btn-info" title="Edit">
                                                <i class="fe fe-edit"></i>
                                            </a>

                                            <!-- <button class="btn btn-sm btn-danger data-delete"
                                                data-id="{{ $r->id }}" title="Delete">
                                                <i class="fe fe-trash-2"></i>
                                            </button> -->
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>

                            </table>
                        </div>
                        {{ $result->links() }}
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

@endsection


@section('js')
<script>
    $("#brochureDataTable").DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false, "pageLength": 25,
    });

    jQuery(document).on('change', '.brochureStatusToggle', function () {
        let checkbox = jQuery(this);
        let id = checkbox.data('id');
        let currentStatus = checkbox.data('status');

        jQuery.ajax({
            url: "{{ url('admin/brochure') }}/" + id,
            type: 'POST',
            data: {
                _token: "{{ csrf_token() }}",
                _method: "PUT",
                currentStatus: currentStatus
            },
            success: function (response) {
                if (response.success) {
                    toastr.success("Status updated successfully");
                    checkbox.data('status', response.newStatus);
                } else {
                    toastr.error("Something went wrong!");
                    checkbox.prop('checked', currentStatus === 'Active');
                }
            }
        });
    });

    jQuery(document).on("click", ".data-delete", function () {
        let obj = jQuery(this);
        let id = obj.data('id');

        if (confirm("Are you sure to Delete Data?")) {
            jQuery.ajax({
                type: "POST",
                url: "{{ url('admin/brochure/soft-delete') }}/" + id,
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function (resp) {
                    toastr.success("Brochure deleted successfully");
                    window.location.reload();
                }
            });
        }
    });
</script>
@endsection
