<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientGallery extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'client_galleries';
    protected $fillable = [
      
		
		'image',
        'status'
    ];
	
	protected $appends = ['image_url'];

	

    public function getImageUrlAttribute($value)

    {

        return  !empty($this->attributes['image'])? asset($this->attributes['image']):null;

    }
}
