<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Careers extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'careers';
    protected $fillable = [
        'name',
		'slug',
        'designation',
		'mobile',
        'email',
        'resume',
        'status'
    ];
	
	protected $appends = ['resume_url'];

	

		public function getResumeUrlAttribute($value)

    {

        return  !empty($this->attributes['resume'])? asset($this->attributes['resume']):null;

    }
}
