<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;


class Blog extends Model
{
    use HasFactory, SoftDeletes, Sluggable;
    protected $table = 'blogs';
    protected $fillable = [
        'name',
		'slug',
        'description',
		'image',
        'status',
        'short_description'
    ];
	
	protected $appends = ['image_url'];

	

		public function getImageUrlAttribute($value)

    {

        return  !empty($this->attributes['image'])? asset($this->attributes['image']):null;

    }


    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'name'
            ]
        ];
    }
    
    
}
