<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Crypt;
use Symfony\Component\HttpFoundation\Response;
use App\Models\VendorPayment;
use Yajra\Datatables\Datatables;
use App\Models\Vendor;
use File;
use Auth;
use DB;
 
class VendorpaymentController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.vendorpayment.',
        'title' => 'Vendor Payment',
        'menu' => 'Vendor Payment',
        'submenu' => '',
    );
    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
     
          
            if ($request->ajax()) {
                $start_date = $request->startDate;
                $end_date = $request->endDate;

                $query = VendorPayment::with(['vendor'])->orderBy('vendor_payments.id', 'DESC');

                if (!empty($start_date)) {
                    if (!empty($end_date)) {
                        $query->where('payment_date', '>=', date('Y-m-d',strtotime($start_date)));
                    } else {
                        $query->where('payment_date', '=',  date('Y-m-d',strtotime($start_date)));
                    }
                }
                if (!empty($end_date)) {
                    $query->where('payment_date', '<=',  date('Y-m-d',strtotime($end_date)));
                }
                
                // Filter by order number if provided
                if ($request->vendor_id) {
                    $query->where('vendor_id',$request->vendor_id);
                }
                
                $records = $query->select('vendor_payments.*')->get();
            
               
                 $sr = 1;   
                return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('sr_no', function ($record) use (&$sr) {
                        return $sr++;
                    })
                    ->editColumn('remarks',function($record){
                        $cleanedRemarks = strip_tags($record->remarks);
    
                        $cleanedRemarks = html_entity_decode($cleanedRemarks, ENT_QUOTES | ENT_HTML5);
                    
                        return $cleanedRemarks;
                    })
                    ->editColumn('payment_date',function($record){
                        return date('d-m-Y',strtotime($record->payment_date));
                    })
                    ->editColumn('status', function ($record) {
                        return '<div class="form-check form-switch">
                                <input class="form-check-input status-toggle" style="margin-left:-10px;" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
                    })
                    ->editColumn('image',function($record){
                        return '<a href="'.$record->image_url.'" target="_blank">View</a>';
                    })
                   
                    ->addColumn('action', function ($record) {
                        return '<a href="'.url('admin/vendorpayment/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit" ><i class="fe fe-edit"></i></a>'.'&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                    })
                    ->rawColumns(['action','sr_no','image','status'])  
                    ->make(true);
            } 
           
           
            return view('admin.vendorpayment.index',$this->data);
        
    }

   
    public function create()
    {
		$vendorpayment = [];
		$vendor = Vendor::get();
        return view('admin.vendorpayment.create')->with(['vendorpayment'=>$vendorpayment,'vendor'=>$vendor]);
    }

   
    public function store(Request $request)
    {
		
        $sValidationRules = [
            'vendor_id' => 'required',
			'txn_id' => 'required',
            'amount' => 'required',
            'payment_mode' => 'required',
            'payment_date' => 'required',
            'image' => 'image|mimes:jpeg,png,jpg,gif|max:5120',
            
           
        ];
		
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect('admin/vendorpayment/create')->withErrors($validator)->withInput();
        }  
		
        $input = $request->all();
	
		$input['payment_date'] = date('Y-m-d',strtotime($request->payment_date));
		
        if($request->hasFile('image')){
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/vendorpayment'), $image);
            $input['image'] = 'uploads/vendorpayment/'.$image;
        } 

       	$admin = New VendorPayment($input);
        
        
        $admin->save();
		
        return redirect('admin/vendorpayment')->withSuccess('Added successfully');
    }

    public function show($id)
    {
		$vendorpayment = VendorPayment::find($id);
        return view('admin.vendorpayment.show')->with(['vendorpayment'=>$vendorpayment]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$vendorpayment = VendorPayment::find($id);
		$vendor = Vendor::get();
        return view('admin.vendorpayment.create',['vendorpayment'=>$vendorpayment,'vendor'=>$vendor]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$vendorpayment = VendorPayment::find($id);
       
		 if ($request->ajax()) {
			 
            if(!empty($request->currentStatus))   
            {  
                if($request->currentStatus == 'Active')
                {
                    $vendorpayment->status = 'Deactive';
                }	
                else{
                    $vendorpayment->status = 'Active';
                }		  
            }
		  $vendorpayment->update();
          $response['success'] = true;
          $response['message'] = 'Update successfully';
          return response()->json($response);
		
			 
		 }
        $sValidationRules = [
           'name' => 'required',
			'txn_id' => 'required',
            'amount' => 'required',
            'payment_mode' => 'required',
            'payment_date' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:5120',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
		$input['payment_date'] = date('Y-m-d',strtotime($request->payment_date));
      
       
        if($request->hasFile('image')){
            if(file_exists(asset($vendor->image))){
                unlink(asset($vendor->image));
            }
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/vendorpayment'), $image);
            $input['image'] = 'uploads/vendorpayment/'.$image;
        } 
        
        $vendorpayment->update($input);
        return redirect('admin/vendorpayment')->withSuccess('Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = VendorPayment::find($request->id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        VendorPayment::where('id', '=', $request->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
	
	 public function vendorpaymentdelete($id)
    {
        $admin = VendorPayment::find($id);
        VendorPayment::where('id', '=', $admin->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
}
