<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Yajra\Datatables\Datatables;
use App\Models\VendorPayment;
use App\Models\VendorAccount;
use App\Models\Vendor;
use App\Models\Sitesetting;
use File;

 
class VendorStatementController extends Controller
{
    
    public function __construct()
    {
      
    }

   
    public function index(Request $request)
    {
     /*
        if ($request->ajax()) {
               
            $records = Vendor::orderBy('id','DESC');
             $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('sr_no', function ($record) use (&$sr) {
                    return $sr++;
                })
               
               /* ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch">
                            <input class="form-check-input status-toggle" style="margin-left:10px;" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
                })  

               

                
                ->addColumn('action', function ($record) {
                    return '<a href="'.url('admin/vendorstatement/'.$record->id) .'" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="" data-bs-original-title="view"><i class="fe fe-eye"></i></a> '.
                          '&nbsp;<a href="'.url('admin/vendorstatement/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['action','sr_no'])
                ->make(true);
        }
     
       
        return view('admin.vendorstatement.index',$this->data);
       */
      $vendors = Vendor::orderBy('id', 'DESC')->get();
      $start_date = $request->startDate;
      $end_date = $request->endDate;
      return view('admin.vendorstatement.index', compact('vendors','start_date','end_date'));
        
    }

   
    public function create()
    {
		$vendorpayment = [];
		$vendor = Vendor::get();
        return view('admin.vendorpayment.create')->with(['vendorpayment'=>$vendorpayment,'vendor'=>$vendor]);
    }

   
    public function store(Request $request)
    {
		
        $sValidationRules = [
            'name' => 'required',
			'txn_id' => 'required',
            'amount' => 'required',
            'payment_mode' => 'required',
            'payment_date' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:5120',
            
           
        ];
		
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect('admin/vendorpayment/create')->withErrors($validator)->withInput();
        }  
		
        $input = $request->all();
	
		$input['payment_date'] = date('Y-m-d',strtotime($request->payment_date));
		$str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$input['slug'] = rtrim($str, '-');
        if($request->hasFile('image')){
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/vendorpayment'), $image);
            $input['image'] = 'uploads/vendorpayment/'.$image;
        } 

       	$admin = New VendorPayment($input);
        
        
        $admin->save();
		
        return redirect('admin/vendorpayment')->withSuccess('Added successfully');
    }

    public function show($id)
    {
		$vendorpayment = VendorPayment::find($id);
        return view('admin.vendorpayment.show')->with(['vendorpayment'=>$vendorpayment]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$vendorpayment = VendorPayment::find($id);
		$vendor = Vendor::get();
        return view('admin.vendorpayment.create',['vendorpayment'=>$vendorpayment,'vendor'=>$vendor]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$vendorpayment = VendorPayment::find($id);
       
		 if ($request->ajax()) {
			 
            if(!empty($request->currentStatus))
            {
                if($request->currentStatus == 'Active')
                {
                    $vendor->status = 'Deactive';
                }	
                else{
                    $vendor->status = 'Active';
                }		  
            }
		  $vendor->save();
		  return 1;
		
			 
		 }
        $sValidationRules = [
           'name' => 'required',
			'txn_id' => 'required',
            'amount' => 'required',
            'payment_mode' => 'required',
            'payment_date' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:5120',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
		$input['payment_date'] = date('Y-m-d',strtotime($request->payment_date));
        $str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$input['slug'] = rtrim($str, '-');
       
        if($request->hasFile('image')){
            if(file_exists(asset($vendor->image))){
                unlink(asset($vendor->image));
            }
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/vendorpayment'), $image);
            $input['image'] = 'uploads/vendorpayment/'.$image;
        } 
        
        $vendorpayment->update($input);
        return redirect('admin/vendorpayment')->withSuccess('Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = VendorPayment::find($request->id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        VendorPayment::where('id', '=', $request->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
	
	 public function vendorpaymentdelete($id)
    {
        $admin = VendorPayment::find($id);
       
        VendorPayment::where('id', '=', $admin->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }


    public function vendorStatementDownload(Request $request){
        $start_date = $request->startDate;
        $end_date = $request->endDate;

        $record['vendor'] = Vendor::where('id',$request->vendorid)->first();
        $data = VendorAccount::select('vendor_accounts.*')->with(['phonenumber'])
                // ->leftjoin('phonenumbers','phonenumbers.id','vendor_accounts.product_id')
                // ->leftjoin('phonenumbers', function ($join) {
                //     $join->on('phonenumbers.id', '=', 'vendor_accounts.product_id');
                // })
                // ->join('orderdetails', function ($join) {
                //     $join->on('orderdetails.order_id', '=', 'vendor_accounts.order_id')
                //         ->on('orderdetails.product_id', '=', 'vendor_accounts.product_id');
                // })
                ->where('vendor_accounts.vendor_id',$request->vendorid)->orderBy('vendor_accounts.id','DESC');
                if (!empty($start_date)) {
                    if (!empty($end_date)) {
                        $data->where('vendor_accounts.created_at', '>=', date('Y-m-d 00:00:00',strtotime($start_date)));
                    } else {
                        $data->where('vendor_accounts.created_at', '=',  date('Y-m-d 00:00:00',strtotime($start_date)));
                    }
                }
                if (!empty($end_date)) {
                    $data->where('vendor_accounts.created_at', '<=',  date('Y-m-d 23:59:59',strtotime($end_date)));
                }
                $data = $data->get();
                $record['data'] = $data;

        $debit = VendorPayment::where('vendor_id',$request->vendorid);
                    if (!empty($start_date)) {
                        if (!empty($end_date)) {
                            $debit->where('created_at', '>=', date('Y-m-d 00:00:00',strtotime($start_date)));
                        } else {
                            $debit->where('created_at', '=',  date('Y-m-d 00:00:00',strtotime($start_date)));
                        }
                    }
                    if (!empty($end_date)) {
                        $debit->where('created_at', '<=',  date('Y-m-d 23:59:59',strtotime($end_date)));
                    }
        $debit = $debit->sum('amount');

        $credit = VendorAccount::select('vendor_accounts.*','phonenumbers.vendor_rate')
                    ->leftjoin('phonenumbers','phonenumbers.id','vendor_accounts.product_id')
                    // ->join('orderdetails', function ($join) {
                    //     $join->on('orderdetails.order_id', '=', 'vendor_accounts.order_id')
                    //         ->on('orderdetails.product_id', '=', 'vendor_accounts.product_id');
                    // })
                    // ->join('orders', 'orders.id', '=', 'orderdetails.order_id')
                    ->where('vendor_accounts.vendor_id', $request->vendorid)
                    // ->where('orders.payment_status', 'Paid');
                    // ->where('orders.payment_status','!=', 'cancelled');
                    ->where('vendor_accounts.payment_elegible','!=', 'C')
                    ->where('vendor_accounts.payment_status','!=', 'C');
                    if (!empty($start_date)) {
                        if (!empty($end_date)) {
                            $credit->where('vendor_accounts.created_at', '>=', date('Y-m-d 00:00:00',strtotime($start_date)));
                        } else {
                            $credit->where('vendor_accounts.created_at', '=',  date('Y-m-d 00:00:00',strtotime($start_date)));
                        }
                    }
                    if (!empty($end_date)) {
                        $credit->where('vendor_accounts.created_at', '<=',  date('Y-m-d 23:59:59',strtotime($end_date)));
                    }
        $credit = $credit->sum('phonenumbers.vendor_rate');


            $record['debit'] =$debit;
            $record['credit'] =$credit;
            $record['sitesetting'] = Sitesetting::first();
        return view('admin.vendorstatement.vendorStatementDownload',$record);
    }
}
