<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Crypt;
use App\Models\VendorAccount;
use Symfony\Component\HttpFoundation\Response;
use Yajra\Datatables\Datatables;
use File;
use Auth;
use DB;
use Carbon\Carbon;
 
class VendorAccountController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.vendoraccount.',
        'title' => 'Vendoraccount',
        'menu' => 'Vendoraccount',
        'submenu' => '',
    );


    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
      
     
        if ($request->ajax()) {
            $records = VendorAccount::orderBy('id','DESC')
                                    ->select('vendor_accounts.*')
                                    ->join('vendors', 'vendors.id', '=', 'vendor_accounts.vendor_id')
                                    ->with(['vendor']);
             $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('sr_no', function ($record) use (&$sr) {
                    return $sr++;
                })
                ->editColumn('payment_date', function ($record)  {
                    if(!empty($record->payment_date)){
                       $date = date('d-m-Y H:m:s',strtotime($record->payment_date));
                       
                    }else{
                        $date = '';
                    }
                    return $date;
                })
                ->editColumn('order_date', function ($record)  {
                    if(!empty($record->order_date)){
                       $date = date('d-m-Y H:m:s',strtotime($record->order_date));
                    }else{
                        $date = '';
                    }
                    return $date;
                })
                ->editColumn('order_pay_date', function ($record)  {
                    if(!empty($record->order_pay_date)){
                       $date = date('d-m-Y H:m:s',strtotime($record->order_pay_date));
                    }else{
                        $date = '';
                    }
                    return $date;
                })
                ->rawColumns(['sr_no'])
                ->make(true);
        }
       
        return view('admin.venderaccount.index',$this->data);
    
    }
}
