<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Service;
use File;
use Auth;
use DB;
use Yajra\Datatables\Datatables;
use Illuminate\Http\Response;

class ServiceController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    private $data = array(
        'route' => 'admin.service.',
        'title' => 'Service',
        'menu' => 'Service',
        'submenu' => '',
    );
    public function __construct()
    {
      
    }

    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
               
            $records = Service::select('services.*');
             $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                ->editColumn('image', function ($record) {
                    $imageUrl = $record->image_url 
                        ? $record->image_url 
                        : asset('public/assets/admin/images/not-available.jpg');
                
                    return '<img src="' . $imageUrl . '" style="height:120px;">';
                })
                
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch" style="left:19px;">
                            <input class="form-check-input status-toggle" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
                })
                ->addColumn('action', function ($record) {
                    return '<a href="'.url('admin/service/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['status','action','image'])
                ->make(true);
        }
          
           
            return view('admin.service.index',$this->data);
        
    }

   
    public function create()
    {
		$service = [];
        return view('admin.service.create')->with(['service'=>$service]);
    }

   
    public function store(Request $request)
    {
        $sValidationRules = [
            'name'=>'required',
            'description'=>'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,webp,svg',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())
        {
            return redirect('admin/service/create')->withErrors($validator)->withInput();
        }        
        $admin = New Service;
        $admin->name = $request->name;
        $admin->description = $request->description;
       
        if($request->hasFile('image')){
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/service'), $image);
            $admin->image = 'uploads/service/'.$image;
        }  
      
        $admin->save();
        return redirect('admin/service')->withSuccess('Added successfully');
    }

    public function show($id)
    {
		$service = Service::find($id);
        return view('admin.service.show')->with(['service'=>$service]);
    }

   
    public function edit($id)
    {
		$service = Service::find($id);
		
        return view('admin.service.create',['service'=>$service]);
    }

 
    public function update(Request $request,Service $service)
    {
	
		 if ($request->ajax()) {
			 if(!empty($request->currentStatus)){
                if($request->currentStatus == 'Active')
                {
                    $service->status = 'Deactive';
                }	
                else{
                    $service->status = 'Active';
                }		  
            }
		  $service->save();
          $response['success'] = true;
          $response['message'] = 'Update successfully';
          return response()->json($response);
			 
		 }
        $sValidationRules = [
            'name'=>'required',
            'description'=>'required',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp,svg|max:10240',
       
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        
        $service->name = $request->name;
     
        $service->description = $request->description;
      if($request->hasFile('image')){
            if(file_exists(asset($service->image))){
                unlink(asset($service->image));
            }
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/service'), $image);
            $service->image = 'uploads/service/'.$image;
        } 
        $service->save();
        return redirect('admin/service')->withSuccess('Update successfully');
    }
  
    public function destroy($id)
    {
        $admin = Service::find($id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Service::where('id', '=', $id)->delete();
        $response['success'] = true;
        $response['message'] = 'Service Deleted successfully';
        return response()->json($response);
    }
	
}
