<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Order;
use App\Models\Customer;
use App\Models\Admin;
use App\Models\Phonenumber;
use App\Models\Orderdetail;
use App\Models\Payment;
use App\Models\VendorAccount;
use Yajra\Datatables\Datatables;
use DB;
use Carbon\Carbon;
class SalesReportController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }

    public function index(Request $request)
    {
         
            if ($request->ajax()) {
                    $records = Orderdetail::select('orderdetails.*')->orderBy('orderdetails.id','DESC')
                                            ->join('orders', 'orders.id', '=', 'orderdetails.order_id')
                                            ->where('orders.order_status', '=','closed_won');
                                           
                                $start_date = $request->startDate;
                                $end_date = $request->endDate;
                                if (!empty($start_date)) {
                                    if (!empty($end_date)) {
                                        $records->where('orderdetails.order_date', '>=', date('Y-m-d 00:00:00',strtotime($start_date)));
                                    } else {
                                        $records->where('orderdetails.order_date', '=',  date('Y-m-d 00:00:00',strtotime($start_date)));
                                    }
                                }
                                if (!empty($end_date)) {
                                    $records->where('orderdetails.order_date', '<=',  date('Y-m-d 23:59:59',strtotime($end_date)));
                                } 
                        $records->with('order','vendor');
             
                 $sr = 1;
                return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('sr_no', function ($record) use (&$sr) {
                        return $sr++;
                    })
                    ->addColumn('order_date', function ($record) { 
                        $date = date('d/m/Y', strtotime($record->order_date));
                        return $date;
                    })
                    ->addColumn('assign_to', function ($record) { 
                        $assign_to = $record->order->employee->name??'-';
                        return $assign_to;
                    })
                    ->addColumn('address', function ($record) { 
                        $address = $record->order->customer->address??'-';
                        return $address;
                    })
                    ->addColumn('state', function ($record) { 
                        $state = $record->order->customer->state??'-';
                        return $state;
                    })
                    ->addColumn('transection', function ($record) { 
                        $payment = Payment::where('order_id',$record->order_id)->first();
                        return $payment->txn_id??'-';
                    })
                    ->addColumn('payment_mode', function ($record) { 
                        $payment = Payment::where('order_id',$record->order_id)->first();
                        return $payment->payment_mode??'-';
                    })
                    ->addColumn('discount', function ($record) { 
                        $discount = $record->number_rate*$record->discount/100;
                        return $discount;
                    })
                    ->addColumn('order_status', function ($record) { 
                        $order_status =str_replace('_', ' ',$record->order->order_status);
                        return $order_status;
                    })
                   
                    ->rawColumns(['sr_no','order_date','assign_to','discount','order_status','address','state','transection']) 
                    ->make(true);
            }
          
            $number_rate = Orderdetail::select('orderdetails.*')->orderBy('orderdetails.id','DESC')
                                            ->join('orders', 'orders.id', '=', 'orderdetails.order_id')
                                            ->where('orders.order_status', '=','closed_won');
                                           
                                $start_date = $request->startDate;
                                $end_date = $request->endDate;
                                if (!empty($start_date)) {
                                    if (!empty($end_date)) {
                                        $number_rate->where('orderdetails.order_date', '>=', date('Y-m-d 00:00:00',strtotime($start_date)));
                                    } else {
                                        $number_rate->where('orderdetails.order_date', '=',  date('Y-m-d 00:00:00',strtotime($start_date)));
                                    }
                                }
                                if (!empty($end_date)) {
                                    $number_rate->where('orderdetails.order_date', '<=',  date('Y-m-d 23:59:59',strtotime($end_date)));
                                } 
            $record['number_rate'] = $number_rate->with('order','vendor')->sum('discount_rate');

            $vendor_rate = Orderdetail::select('orderdetails.*')->orderBy('orderdetails.id','DESC')
                            ->join('orders', 'orders.id', '=', 'orderdetails.order_id')
                            ->where('orders.order_status', '=','closed_won');
           
                            $start_date = $request->startDate;
                            $end_date = $request->endDate;
                            if (!empty($start_date)) {
                                if (!empty($end_date)) {
                                    $vendor_rate->where('orderdetails.order_date', '>=', date('Y-m-d 00:00:00',strtotime($start_date)));
                                } else {
                                    $vendor_rate->where('orderdetails.order_date', '=',  date('Y-m-d 00:00:00',strtotime($start_date)));
                                }
                            }
                            if (!empty($end_date)) {
                                $vendor_rate->where('orderdetails.order_date', '<=',  date('Y-m-d 23:59:59',strtotime($end_date)));
                            } 
            $record['vendor_rate'] = $vendor_rate->with('order','vendor')->sum('vendor_rate');
            return view('admin.salesreport.index',$record);
        
    }

}
