<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Product;
use App\Models\Category;
use File;
use Auth;
use DB;
use Yajra\Datatables\Datatables;
use Illuminate\Http\Response;

class ProductController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    private $data = array(
        'route' => 'admin.product.',
        'title' => 'Product',
        'menu' => 'Product',
        'submenu' => '',
    );
    public function __construct()
    {
      
    }

    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
               
            $records = Product::with(['category'])->orderBy('id','desc')->select('products.*');
             $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                ->editColumn('image', function ($record) {
                    return '<img src="' . $record->image_url . '" style=" height:120px;">';
                })
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch" style="left:19px;">
                            <input class="form-check-input status-toggle" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
                })
                ->addColumn('action', function ($record) {
                    return '<a href="'.url('admin/product/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['status','action','image'])
                ->make(true);
        }
          
           
            return view('admin.product.index',$this->data);
        
    }

   
    public function create()
    {
		$product = [];
       
        return view('admin.product.create')->with(['product'=>$product]);
    }

   
    public function store(Request $request)
    {
        $sValidationRules = [
            'name'=>'required',
            'category_id'=>'required',
            'description'=>'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,webp',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect('admin/product/create')->withErrors($validator)->withInput();
        }        
        $admin = New Product;
        $admin->name = $request->name;
        $admin->category_id = $request->category_id;
        $admin->description = $request->description;
       
        $str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$admin->slug = rtrim($str, '-');
        if($request->hasFile('image')){
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/product'), $image);
            $admin->image = 'uploads/product/'.$image;
        }  
      
        $admin->save();
        return redirect('admin/product')->withSuccess('Added successfully');
    }

    public function show($id)
    {
		$product = Product::find($id);
        return view('admin.product.show')->with(['product'=>$product]);
    }

   
    public function edit($id)
    {
		$product = Product::find($id);
      
        return view('admin.product.create')->with(['product'=>$product]);
    }

 
    public function update(Request $request,product $product)
    {
	
		 if ($request->ajax()) {
			 if(!empty($request->currentStatus)){
                if($request->currentStatus == 'Active')
                {
                    $product->status = 'Deactive';
                }	
                else{
                    $product->status = 'Active';
                }		  
            }
		  $product->save();
          $response['success'] = true;
          $response['message'] = 'Update successfully';
          return response()->json($response);
			 
		 }
        $sValidationRules = [
            
             'name'=>'required',
             'category_id'=>'required',
             'description'=>'required',
             'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:10240',
       
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        
        $product->name = $request->name;
        $product->category_id = $request->category_id;
        $product->description = $request->description;
        $str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$product->slug = rtrim($str, '-');
      if($request->hasFile('image')){
            if(file_exists(asset($product->image))){
                unlink(asset($product->image));
            }
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/product'), $image);
            $product->image = 'uploads/product/'.$image;
        } 
        $product->save();
        return redirect('admin/product')->withSuccess('Update successfully');
    }
  
    public function destroy($id)
    {
        $admin = Product::find($id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Product::where('id', '=', $id)->delete();
        $response['success'] = true;
        $response['message'] = 'Product Deleted successfully';
        return response()->json($response);
    }
	
}
