<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Portfolio;
use App\Models\Service;
use File;
use Auth;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\Phonenumber;


class PortfolioController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }

    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    private $data = array(
        'route' => 'admin.portfolio.',
        'title' => 'Portfolio',
        'menu' => 'Portfolio',
        'submenu' => '',
    );
    public function index(Request $request)
    {
       
        if ($request->ajax()) {
               
            $records = Portfolio::select('portfolioes.*');
             $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                ->editColumn('created_at', function ($record) {
                    return $record->created_at->format('d/m/Y');
                })

                ->editColumn('image', function($record){
                    return '<img src="' . $record->image_url . '" style=" height:120px;">';
                })
                
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch" style="left:19px;">
                            <input class="form-check-input status-toggle" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
                })
                ->addColumn('action', function ($record) {
                    return '<a href="'.url('admin/portfolio/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
               
                
                ->rawColumns(['status','action','sr_no','image'])
                ->make(true);
        }
            return view('admin.portfolio.index',$this->data);
        
    }
    public function create()
    {
		$portfolio = [];
        return view('admin.portfolio.create')->with(['portfolio'=>$portfolio]);
    }

   
    public function store(Request $request)
    {
        $sValidationRules = [
            'name' => 'required',
            'servicecategory' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,webp',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }        
        $admin = New Portfolio;
        $admin->name = $request->name;
        $admin->servicecategory = $request->servicecategory;
		
		$str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$admin->slug = rtrim($str, '-');
       
       
          if($request->hasFile('image')){
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/portfolio'), $image);
            $admin->image = 'uploads/portfolio/'.$image;
        } 
      
        $admin->save();
        return redirect('admin/portfolio')->withSuccess('Portfolio Added Successfully');
    }

    public function show($id)
    {
		$portfolio = Portfolio::find($id);
        return view('admin.portfolio.show')->with(['portfolio'=>$portfolio]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $brands
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$portfolio = Portfolio::find($id);
		
        return view('admin.portfolio.create',['portfolio'=>$portfolio]);
    }

 
    public function update(Request $request,Portfolio $portfolio)
    {
	
		 if ($request->ajax()) {
			 
			 if(!empty($request->currentStatus))
		{
	      if($request->currentStatus == 'Active')
          {
			  $portfolio->status = 'Deactive';
		  }	
          else{
			  $portfolio->status = 'Active';
		  }		  
		}
		  $portfolio->save();
		  $response['success'] = true;
        $response['message'] = 'Update successfully';
        return response()->json($response);
		
			 
		 }
        $sValidationRules = [
             'name' => 'required',
             'servicecategory.*' => 'required',
             'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp',
       
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
		
		
        $portfolio->servicecategory = $request->servicecategory;
		
        $portfolio->name = $request->name;
     
        $str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$portfolio->slug = rtrim($str, '-');
      
        
       
      if($request->hasFile('image')){
            if(file_exists(asset($portfolio->image))){
                unlink(asset($portfolio->image));
            }
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/portfolio'), $image);
            $portfolio->image = 'uploads/portfolio/'.$image;
        } 
        $portfolio->save();
        return redirect('admin/portfolio')->withSuccess('Portfolio Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $brands
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = Portfolio::find($request->id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Portfolio::where('id', '=', $request->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Update successfully';
        return response()->json($response);
    }
	

}
