<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Inquiry;
use Illuminate\Support\Facades\Session;
use File;
use Auth;
use DB;
use Yajra\Datatables\Datatables;
use Illuminate\Http\Response;
class InquiryController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
               
            $records = Inquiry::select('inquiries.*');
             
            return Datatables::of($records)
                ->addIndexColumn()
              
               
                ->rawColumns([''])
                ->make(true);
        }
          
           
            return view('admin.inquiry.index');
        
    }
    
    public function saveinquiry(Request $request)
    {
        
        $sValidationRules = [
           
            'name' =>'required',
            'email'=>'required|email',
            'mobile' => 'required|numeric|digits:10',
            
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }  
        
       
        $input = $request->all();
        $inquiry = new Inquiry($input);
        $inquiry->save();
      
        Session::flash('success', 'We appreciate your interest! Your inquiry has been submitted, and our team will contact you soon with the necessary details.');

        return redirect()->back();
    }
}