<?php
namespace App\Http\Controllers\AdminAuth;
use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\Slider;
use App\Models\Service;
use App\Models\Testimonial;
use App\Models\Media;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use File;
use Hash;


class HomeController extends Controller
{
    public function dashboard(Request $request)
    {
        $sliderCount = Slider::count();
        $serviceCount = Service::count();
        $testimonialCount = Testimonial::count();
        $mediaCount = Media::count();
        return view('admin.dashboard', compact('sliderCount', 'serviceCount', 'testimonialCount', 'mediaCount'));
    }
    public function profile_edit(){
      
        return view('admin.profile_edit');
    }
    public function profile_update(Request $request){
        $admin = Admin::where('id',Auth::guard('admin')->user()->id)->first();
        $admin->name = $request->name;
        $admin->email = $request->email;
        if ($request->password) {
            $admin->password = Hash::make($request->password);
            $admin->show_password = $request->password;
        }
        if($request->hasFile('profile_image')){
            if (File::exists(asset($admin->profile_image))) {
                File::delete(asset($admin->profile_image));
            }
            $image = rand().time().'.'.$request->profile_image->extension();
            $request->profile_image->move(public_path('uploads/employee'), $image);
            $admin->profile_image = 'uploads/employee/'.$image;
        } 
       
        $admin->update();
        return redirect()->back()->with('success', 'Profile updated successfully');
    }
    public function calculatenumbertotal (Request $request){
        $number = preg_replace('/\D/', '', $request->phonenumber);
        $num = preg_replace("/[^0-9\s]+/", "", $number);
        $total_numeber_sum = array_sum(str_split($number));
        $total_sum = array_sum(str_split($total_numeber_sum));
        $final_sum = array_sum(str_split($total_sum));
       return "<center><p>Two Digit Result : <b>$total_numeber_sum</b> &nbsp;&nbsp;<b></b> &nbsp;&nbsp; Single Digit Result : <b>$total_sum</b> </p></center>";
    }

    function convertwordtonumber(Request $request) {
        $number = "0";
        $input = str_replace(' ', '', strtoupper($request->nephone)); // Remove spaces and convert to uppercase
        $length = strlen($input);
    
        for ($i = 0; $i < $length; $i++) {
            $char = $input[$i];
    
            if (ctype_alpha($char)) {
                switch ($char) {
                    case 'A': case 'B': case 'C': $number = $number * 10 + 2; break;
                    case 'D': case 'E': case 'F': $number = $number * 10 + 3; break;
                    case 'G': case 'H': case 'I': $number = $number * 10 + 4; break;
                    case 'J': case 'K': case 'L': $number = $number * 10 + 5; break;
                    case 'M': case 'N': case 'O': $number = $number * 10 + 6; break;
                    case 'P': case 'Q': case 'R': case 'S': $number = $number * 10 + 7; break;
                    case 'T': case 'U': case 'V': $number = $number * 10 + 8; break;
                    case 'W': case 'X': case 'Y': case 'Z': $number = $number * 10 + 9; break;
                }
            } elseif (ctype_digit($char)) {
                $number = $number * 10 + $char;
            } else {
                return response()->json(['error' => 'Invalid character: ' . $char]);
            }
        }
    
        return response()->json(['number' => $number]);
    }
}

    