<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Education;
use File;
use Auth;
use DB;
use Yajra\Datatables\Datatables;
use Illuminate\Http\Response;
class EducationController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    private $data = array(
        'route' => 'admin.education.',
        'title' => 'Education',
        'menu' => 'education',
        'submenu' => '',
    );
    public function __construct()
    {
      
    }

    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $records = Education::select('education.*');

            return Datatables::of($records)
                ->addIndexColumn()
                ->editColumn('image1', function ($record) {
                    return $record->image1
                        ? '<img src="' . asset($record->image1) . '" style="height:80px;">'
                        : '<img src="' . asset('assets/user/images/not-availbale.png') . '" style="height:80px;">';
                })
                /*->editColumn('image2', function ($record) {
                    return $record->image2
                        ? '<img src="' . asset($record->image2) . '" style="height:80px;">'
                        : '<img src="' . asset('assets/user/images/not-availbale.png') . '" style="height:80px;">';
                })
                ->editColumn('image3', function ($record) {
                    return $record->image3
                        ? '<img src="' . asset($record->image3) . '" style="height:80px;">'
                        : '<img src="' . asset('assets/user/images/not-availbale.png') . '" style="height:80px;">';
                })*/
                ->addColumn('action', function ($record) {
                    return '<a href="' . url('admin/education/' . $record->id . '/edit') . '" 
                            class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="Edit">
                            <i class="fe fe-edit"></i></a>';
                })
                ->rawColumns(['action', 'image1', 'image2', 'image3'])
                ->make(true);
        }

        return view('admin.education.index', $this->data);
    }

    public function show($id)
    {
		$education = Education::find($id);
        return view('admin.education.show')->with(['education'=>$education]);
    }

   
    public function edit($id)
    {
		$education = Education::find($id);
		
        return view('admin.education.create',['education'=>$education]);
    }

 
    public function update(Request $request, Education $education)
    {
        if ($request->ajax()) {
            if (!empty($request->currentStatus)) {
                $education->status = ($request->currentStatus == 'Active') ? 'Deactive' : 'Active';
            }
            $education->save();
    
            return response()->json([
                'success' => true,
                'message' => 'Status updated successfully'
            ]);
        }

        $rules = [
            'name'        => 'required|string|max:255',
            'title'       => 'required|string|max:255',
            'description' => 'required|string',
            'image1'      => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
            /*'image2'      => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
            'image3'      => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',*/
        ];
    
        $validator = Validator::make($request->all(), $rules);
    
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $education->name        = $request->name;
        $education->title       = $request->title;
        $education->description = $request->description;
        foreach (['image1', 'image2', 'image3'] as $field) {
            if ($request->hasFile($field)) {
                if (!empty($education->$field)) {
                    $oldPath = public_path($education->$field);
                    if (file_exists($oldPath)) {
                        unlink($oldPath);
                    }
                }
                $fileName = uniqid() . '.' . $request->file($field)->extension();
                $request->file($field)->move(public_path('uploads/education'), $fileName);
                $education->$field = 'uploads/education/' . $fileName;
            }
        }        

        $education->save();
    
        return redirect('admin/education')->withSuccess('Education updated successfully');
    }
    
  
    public function destroy($id)
    {
        $admin = Education::find($id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Education::where('id', '=', $id)->delete();
        $response['success'] = true;
        $response['message'] = 'Education Deleted successfully';
        return response()->json($response);
    }
	
}
