<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Coupon;
use File;
use Auth;
use DB;
use Symfony\Component\HttpFoundation\Response;
use Yajra\Datatables\Datatables;
class CouponController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.coupon.',
        'title' => 'Coupon',
        'menu' => 'Coupon',
        'submenu' => '',
    );

    public function index(Request $request)
    {
       
            if ($request->ajax()) {
               
                $records = Coupon::select('coupons.*')->orderBy('id','DESC');
                 $sr = 1;
                return Datatables::of($records)
                    ->addIndexColumn()
                    ->editColumn('valid_upto', function ($record) {
                        return date('d-m-Y', strtotime($record->valid_upto));
                    })
                    ->editColumn('coupon_type', function ($record) {
                        if(!empty($record->buy_x) && !empty($record->buy_discount)){
                            $coupon_discription = 'Buy '.$record->buy_x.' Get FLAT '.$record->buy_discount.'% OFF';
                         } else if(!empty($record->buy_x) && !empty($record->free_x)){
                            $coupon_discription = 'Special offer Buy '.$record->buy_x.' Get '.$record->free_x.' Free';
                         } else if($record->coupon_type == 'Percentage' && $record->coupon_value != ''){
                            $coupon_discription = 'Flat '.$record->coupon_value.'% OFF';
                         } else {
                            $coupon_discription = 'Flat ₹'.$record->coupon_value.' OFF';
                         }
                        return $coupon_discription;
                    })
                    ->addColumn('action', function ($record) {
                        return '<a href="'.url('admin/coupon/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                              '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                    })
                    ->rawColumns(['action'])
                    ->make(true);
            }
            return view('admin.coupon.index',$this->data);
        
    }

    public function create()
    {
		$coupons = null;
        return view('admin.coupon.create')->with(['coupons'=>$coupons]);
    }

    public function store(Request $request)
    {
		
        $sValidationRules = [
            'coupon_code' => 'required',
			// 'coupon_type' => 'required',
            // 'coupon_value' => 'required',
            // 'max_discount_value' => 'required',
            // 'minimum_cart_value' => 'required',
            // 'maxmum_cart_value' => 'required',
            'valid_upto' => 'required',
        ];
		
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()){
            return redirect('admin/coupon/create')->withErrors($validator)->withInput();
        }  
		
        $input = $request->all();
        $input['valid_upto'] = date('Y-m-d', strtotime($request->valid_upto));
       	$admin = New Coupon($input);
        $admin->save();
		
        return redirect('admin/coupon')->withSuccess('Added successfully');
    }

    public function edit($id)
    {
		$coupons = Coupon::find($id);
        return view('admin.coupon.create',['coupons'=>$coupons]);
    }
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$Coupon = Coupon::find($id);
       
        $sValidationRules = [
            'coupon_code' => 'required',
			// 'coupon_type' => 'required',
            // 'coupon_value' => 'required',
            // 'max_discount_value' => 'required',
            // 'minimum_cart_value' => 'required',
            'valid_upto' => 'required',
        ];
		
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect('admin/coupon/create')->withErrors($validator)->withInput();
        }  
        $input['valid_upto'] = date('Y-m-d', strtotime($request->valid_upto));
        $Coupon->update($input);
        return redirect('admin/coupon')->withSuccess('Update successfully');
    }

 

   

 
}
