<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Careers;
use File;
use Auth;
use DB;
 
class CareersController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }

    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       
          
            $query = Careers::where('id','>','0');
            // Search Start
          
           
            $result = $query->orderBy('id','DESC')->paginate(5);
			
            return view('admin.careers.index')->with(['result'=>$result]);
        
    }

   
    public function create()
    {
		$careers = [];
        return view('admin.careers.create')->with(['careers'=>$careers]);
    }

   
    public function store(Request $request)
    {
        $sValidationRules = [
            'name' => 'required',
            'designation' => 'required',
            'mobile' => 'required|numeric|digits:10',
            'email' => 'required|email',
            'resume' => 'required|image|mimes:jpeg,png,jpg,gif,pdf|max:2048',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }        
        $input = $request->all();
		
		$str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$input['slug'] = rtrim($str, '-');
       
       
          if($request->hasFile('resume')){
            $image = rand().time().'.'.$request->resume->extension();
            $request->resume->move(public_path('uploads/careers'), $image);
            $input['resume'] = 'uploads/careers/'.$image;
        } 
		$admin = new Careers($input);
      
        $admin->save();
        return redirect('admin/careers')->withSuccess('Added successfully');
    }

    public function show($id)
    {
		$careers = Careers::find($id);
        return view('admin.careers.show')->with(['careers'=>$careers]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$careers = Careers::find($id);
		
        return view('admin.careers.create',['careers'=>$careers]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$careers = Careers::find($id);
	
		 if ($request->ajax()) {
			 
			 if(!empty($request->currentStatus))
		{
	      if($request->currentStatus == 'Active')
          {
			  $careers->status = 'Deactive';
		  }	
          else{
			  $careers->status = 'Active';
		  }		  
		}
		  $careers->save();
		  return 1;
		
			 
		 }
         $sValidationRules = [
            'name' => 'required',
            'designation' => 'required',
            'mobile' => 'required|numeric|digits:10',
            'email' => 'required|email',
            'resume' => 'nullable|image|mimes:jpeg,png,jpg,gif,pdf|max:2048',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
		
		
       
       
     
        $str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$input['slug'] = rtrim($str, '-');
      
        
       
      if($request->hasFile('resume')){
            if(file_exists(asset($careers->resume))){
                unlink(asset($careers->resume));
            }
            $image = rand().time().'.'.$request->image->extension();
            $request->resume->move(public_path('uploads/careers'), $image);
            $input['resume'] = 'uploads/careers/'.$image;
        } 
		
		if(empty($request->resume))
		{
			unset($input['resume']);
		}
        $careers->update($input);
        return redirect('admin/careers')->withSuccess('Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = Careers::find($request->id);
        if (File::exists(public_path($admin['resume']))) {
            File::delete(public_path($admin['resume']));
        } 
        Careers::where('id', '=', $request->id)->delete();
        return redirect(route('admin.careers'))->withSuccess('Deleted successfully');
    }
	
	 public function careersdelete($id)
    {
        $admin = Careers::find($id);
        if (File::exists(public_path($admin['resume']))) {
            File::delete(public_path($admin['resume']));
        } 
        Careers::where('id', '=', $id)->delete();
        return 1;
    }
}
