<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Commission;
use App\Models\Phonenumber;
use App\Models\BulkFileDetail;
use Yajra\Datatables\Datatables;

class BulkUploadController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
    }
    private $data = array(
        'route' => 'admin.bulkuploadstatus.',
        'title' => 'Bulk Upload Status',
        'menu' => 'bulkuploadstatus',
        'submenu' => '',
    );

    public function index(Request $request)
    {

        if ($request->ajax()) {

            $records = BulkFileDetail::select('bulk_file_details.*')->orderBy('id', 'DESC');
            $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('sr_no', function ($record) use (&$sr) {
                    return $sr++;
                })
                ->editColumn('updated_at', function ($record) {
                    return $record->updated_at->format('d-m-Y H:i:s');
                })
                ->editColumn('upload_file', function ($record) {
                    $uploadFilePath = str_replace('uploads/csv/upload_csv/', '', $record->upload_file);
                    return '<a href="' . url($record->upload_file) . '" >' . $uploadFilePath . '</a>';
                })
                ->editColumn('error_file', function ($record) {
                    $uploadFilePath = str_replace('uploads/csv/error_csv/', '', $record->error_file);
                    return '<a href="' . url("$record->error_file") . '" >' . $uploadFilePath . '</a>';
                })
                ->rawColumns(['sr_no', 'upload_file', 'error_file'])
                ->make(true);
        }

        return view('admin.bulkupload.index', $this->data);
    }

    public function bulkNumberUpload()
    {
        return view('admin.phonenumber.bulknumberupload');
    }

    /* public function bulkupload(Request $request){
     
        if ($request->hasFile('number_upload')) {
            $file = $request->file('number_upload');
            // print_r($request->number_upload->extension());exit;
            $csvData = array_map('str_getcsv', file($file));
    
            array_shift($csvData);
            $wrongnumber = [];
            $successfullySavedNumbers = 0;
            foreach ($csvData as $data) {
            
                try{
                    $numberWithoutSpaces = str_replace(' ', '', $data[2]);
                
                    $numberWithoutcharac  =  preg_replace('/[^0-9]/', '', $numberWithoutSpaces);
                
                    $numberOfDigits = strlen($numberWithoutcharac);
            
                    if (ctype_digit($numberWithoutcharac) && $numberOfDigits == 10) {
                        $phonenumber = Phonenumber::where('actual_number',$numberWithoutcharac)->first();
                        if($phonenumber){
                            if($phonenumber->status == 'Available'){
                                $phonenumber->category_id = $data[0];
                                $phonenumber->vendor_id = $data[1];

                                $numbersArray = str_split($numberWithoutcharac);
                                $totalNumber = array_sum($numbersArray);
                                $phonenumber->total_number = $totalNumber;

                                $numbersArray = str_split($totalNumber);
                                $total_sum = array_sum($numbersArray);
                                $phonenumber->total_sum = $total_sum;

                                $numbersArray = str_split($total_sum);
                                $final_sum = array_sum($numbersArray);
                                $phonenumber->final_sum = $final_sum;

                                $phonenumber->actual_number = $numberWithoutcharac;
                            
                                $num = preg_replace("/[^0-9\s]+/", "", $data[2]);
                            
                                
                                $phonenumber->number = $num;
                                $phonenumber->parent_operator = $data[3];
                                $phonenumber->current_operator = $data[4];
                                $phonenumber->circle = $data[5];
                                $phonenumber->number_status = $data[6]; 
                                $phonenumber->dealer_name = $data[7];
                                $phonenumber->dealer_contact = $data[8];

                                $phonenumber->number_rate = $data[9];
                                $comission = Commission::where('from_amount','<=',$data[10])->where('to_amount','>=',$data[10])->first();

                           
                                if($comission)
                                {
                                    if($comission->commission == null || $comission->commission == 0 )
                                    {
                                        $phonenumber->price = $comission->commission_flat + $data[10] ;
                                    }
                                    else{
                                        $c = ($data[10] * $comission->commission)/100;
                                        $phonenumber->price = $c + $data[10];
                                    }
                                }
                                else{

                                    $phonenumber->price = $data[10];
                                }

                            
                                $phonenumber->vendor_rate = $data[10];

                                $phonenumber->discount = $data[11];
                                $phonenumber->highlight_number = $data[12];
                                $phonenumber->save();
                            }
                        }else{
                            $phonenumber = New Phonenumber();
                            $phonenumber->category_id = $data[0];
                            $phonenumber->vendor_id = $data[1];

                            $numbersArray = str_split($numberWithoutcharac);
                            $totalNumber = array_sum($numbersArray);
                            $phonenumber->total_number = $totalNumber;

                            $numbersArray = str_split($totalNumber);
                            $total_sum = array_sum($numbersArray);
                            $phonenumber->total_sum = $total_sum;

                            $numbersArray = str_split($total_sum);
                            $final_sum = array_sum($numbersArray);
                            $phonenumber->final_sum = $final_sum;

                            $phonenumber->actual_number = $numberWithoutcharac;
                            $num = preg_replace("/[^0-9\s]+/", "", $data[2]);
                            
                            $phonenumber->number = $num;
                            $phonenumber->parent_operator = $data[3];
                            $phonenumber->current_operator = $data[4];
                            $phonenumber->circle = $data[5];
                            $phonenumber->number_status = $data[6];
                            $phonenumber->dealer_name = $data[7];
                            $phonenumber->dealer_contact = $data[8];
                            $phonenumber->number_rate = $data[9];

                            $comission = Commission::where('from_amount','<=',$data[10])->where('to_amount','>=',$data[10])->first();
                                if($comission)
                                {
                                    if($comission->commission == null || $comission->commission == 0 )
                                    {
                                        $phonenumber->price = $comission->commission_flat + $data[10] ;
                                    }
                                    else{
                                        $c = ($data[10] * $comission->commission)/100;
                                        $phonenumber->price = $c + $data[10];
                                    }
                                }
                                else{

                                    $phonenumber->price = $data[10];
                                }
                            $phonenumber->vendor_rate = $data[10];
                            $phonenumber->discount = $data[11];
                            $phonenumber->highlight_number = $data[12];
                            $phonenumber->save();
                        }
                        $successfullySavedNumbers++;
                    }else{
                        if($numberOfDigits != 10){
                            $error_array = array();
                            $error_array['number'] =$data[2];
                            $error_array['error_message'] = '10 digit validation failed';
                            $wrongnumber[] = $error_array;
                        }
                        if(!ctype_digit($numberWithoutcharac)){
                            $error_array = array();
                            $error_array['number'] =$data[2];
                            $error_array['error_message'] = 'Special characters validation failed';
                            $wrongnumber[] = $error_array;
                        }
                    }
                }catch(\Exception $e){
                    $error_array = array();
                    $error_array['number'] =$data[2];
                    $error_array['error_message'] = $e->getMessage();
                    $wrongnumber[] = $error_array;
                }
            }
            $wrongNumbersCount = count($wrongnumber);
            if ($wrongNumbersCount > 0) {
                // Generate CSV file
                $csvFileName = rand().time().'.csv';
                $csvFilePath = public_path('uploads/csv/error_csv/' . $csvFileName);
            
                $csvFile = fopen($csvFilePath, 'w');
                fputcsv($csvFile, ['Vanity Number','error']);
            
                foreach ($wrongnumber as $row) {
                    fputcsv($csvFile, $row);
                }
                fclose($csvFile);

                
            }   
            // <=====================BulkFileDetail==========================>
            $bulk_details = new BulkFileDetail();

            $upload_file = rand().time().'.csv';
            $request->number_upload->move(public_path('uploads/csv/upload_csv'), $upload_file);
            $bulk_details->upload_file = 'uploads/csv/upload_csv/' . $upload_file;
            if ($wrongNumbersCount > 0) {
                $bulk_details->error_file = 'uploads/csv/error_csv/' . $csvFileName;
            }else{
                $bulk_details->error_file = null;
            }
            $bulk_details->save();
            // <=====================End==========================>
            
            $response['successfullySavedNumbers'] = $successfullySavedNumbers;
            $response['wrongNumbersCount'] = count($wrongnumber);
            $response['success'] = true;
            $response['message'] = 'CSV file uploaded successfully.';
            return response()->json($response);
            // return redirect()->back()->with('success', 'CSV file uploaded successfully.');
        }
    }
   */

    public function bulkupload(Request $request)
    {
        if (!$request->hasFile('number_upload')) {
            return response()->json(['success' => false, 'message' => 'No file uploaded.']);
        }

        $file = $request->file('number_upload');
        $csvData = array_map('str_getcsv', file($file));
        array_shift($csvData);

        $wrongNumbers = [];
        $successfullySavedNumbers = 0;
        // $isFirstRow = true;
        foreach ($csvData as $data) {
            try {
                // if ($isFirstRow) {
                //     $isFirstRow = false;
                //     continue;
                // }
                // $number = preg_replace('/\D/', '', $data[2]);
                $number = str_replace(' ', '', $data[2]);
                $alphabets = preg_replace('/[^a-zA-Z]/', '', $number);
                if (strlen($number) != 10 || !empty($alphabets)) {
                    $error = ['number' => $data[2], 'error_message' => 'Invalid number format'];
                    $wrongNumbers[] = $error;
                    continue;
                }

                /*$phonenumber = Phonenumber::firstOrNew(['actual_number' => $number]);
                if ($phonenumber->exists && $phonenumber->status !== 'Available') {
                    $error = ['number' => $data[2], 'error_message' => 'Phone number already exists and Sold Out.'];
                    $wrongNumbers[] = $error;
                    continue;
                }*/
                
                // dd($data[2]);
                $phonenumber = Phonenumber::withTrashed()->where('actual_number', $number)->first();
                if ($phonenumber) {
                    if ($phonenumber->trashed() && $phonenumber->status != 'Sold') {
                        $phonenumber->restore();
                    }
                    if ($phonenumber->status == 'Sold') {
                        $error = ['number' => $data[2], 'error_message' => 'Phone number already exists and Sold Out.'];
                        $wrongNumbers[] = $error;
                        continue;
                    }
                } else {
                    $phonenumber = new Phonenumber();
                }
                   
                $num = preg_replace("/[^0-9\s]+/", "", $data[2]);
                
                $total_numeber_sum = array_sum(str_split($number));
                $total_sum = array_sum(str_split($total_numeber_sum));
                $final_sum = array_sum(str_split($total_sum));
                $phonenumber->fill([
                    'category_id' => $data[0]==''?null:$data[0],
                    'vendor_id' => $data[1]==''?null:$data[1],
                    'total_number' => $total_numeber_sum,
                    'total_sum' => $total_sum,
                    'final_sum' => $final_sum,
                    'actual_number' => $number,
                    'number' => trim($num),
                    'parent_operator' => $data[3]==''?null:$data[3],
                    'current_operator' => $data[4]==''?null:$data[4],
                    'circle' => $data[5]==''?null:$data[5],
                    'number_status' => $data[6]==''?null:$data[6],
                    'dealer_name' => $data[7]==''?null:$data[7],
                    'dealer_contact' => $data[8]==''?null:$data[8],
                    // 'number_rate' => ceil($data[9]),
                    'original_rate' => $data[9]==''?null:$data[9],
                    // 'price' => $this->calculatePrice($data[10]),
                    'number_rate' => $this->calculatePrice($data[10]),
                    'vendor_rate' => $data[10]==''?null:$data[10],
                    'discount' => $data[11]==''?null:$data[11],
                    'highlight_number' => $data[12]==''?null:$data[12],
                    'sequence' => $data[13]==''?null:$data[13],
                    'activation_date' => $data[14]==''?null:$data[14],
                    'status' => 'Available',
                    'employee_name' => auth()->user()->name,
                ]);
                $phonenumber->save();
                $successfullySavedNumbers++;
               
            } catch (\Exception $e) {
                $error = ['number' => $data[2], 'error_message' => $e->getMessage()];
                $wrongNumbers[] = $error;
            }
        }

        $wrongNumbersCount = count($wrongNumbers);

        if ($wrongNumbersCount > 0) {
            $errorCsvFileName = rand() . time() . '.csv';
            $errorCsvFilePath = public_path('uploads/csv/error_csv/' . $errorCsvFileName);
            $errorCsvFile = fopen($errorCsvFilePath, 'w');
            fputcsv($errorCsvFile, ['Vanity Number', 'Error']);
            foreach ($wrongNumbers as $row) {
                fputcsv($errorCsvFile, $row);
            }
            fclose($errorCsvFile);
        }

        $bulkDetails = new BulkFileDetail();
        $uploadFileName = rand() . time() . '.csv';
        $request->number_upload->move(public_path('uploads/csv/upload_csv'), $uploadFileName);
        $bulkDetails->upload_file = 'uploads/csv/upload_csv/' . $uploadFileName;
        $bulkDetails->error_file = ($wrongNumbersCount > 0) ? 'uploads/csv/error_csv/' . $errorCsvFileName : null;
        $bulkDetails->name = auth()->user()->name??'';
        $bulkDetails->save();

        return response()->json([
            'successfullySavedNumbers' => $successfullySavedNumbers,
            'wrongNumbersCount' => $wrongNumbersCount,
            'success' => true,
            'message' => 'CSV file uploaded successfully.'
        ]);
    }

    private function calculatePrice($data)
    {
        $commission = Commission::where('from_amount', '<=', $data)->where('to_amount', '>=', $data)->first();
        // dd( $commission);
        if (!$commission) {
            return $data;
        }

        if ($commission->commission == null || $commission->commission == 0) {
            return ceil((int)$commission->commission_flat + (int)$data);
        } else {
            $commissionAmount = ($data * $commission->commission) / 100;
            return ceil($commissionAmount + (int)$data);
        }
    }

    public function bulkNumberStatusUpdate(Request $request)
    {
        return view('admin.phonenumber.bulkNumberStatusUpdate');
    }

    public function bulknumberupdate(Request $request)
    {
        if ($request->action == 'Update') {
            $explode = preg_split('/\s+/', str_replace(' ', '', $request->number));
            foreach($explode as $ex) {
                $cleanedNumber = preg_replace('/\D/', '', $ex);
                $number = Phonenumber::where('actual_number', $cleanedNumber)->where('status','!=','Sold')->first();
                if($number){
                    $number->status = $request->status;
                    $number->update();
                }
            }
            return redirect()->back()->withSuccess('Number Update successfully');
        } else if($request->action == "Delete") {
            $explode = preg_split('/\s+/', str_replace(' ', '', $request->number));
            foreach($explode as $ex){
                $cleanedNumber = preg_replace('/\D/', '', $ex);
                $number = Phonenumber::where('actual_number', $cleanedNumber)->first();
                if($number){
                    if($number->status != 'Sold'){
                        $number->delete();
                    }
                }
            }
            return redirect()->back()->withSuccess('Number Delete successfully');

        }
       
    }
}
