<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Brochure;
use File;
use DB;

class BrochureController extends Controller
{
    public function __construct()
    {
        //
    }

    /** List Page */
    public function index(Request $request)
    {
        $query = Brochure::whereNull('deleted_at');
        $count = $query->count();
        $result = $query->orderBy('id','DESC')->paginate(5);

        return view('admin.brochure.index')->with(['result' => $result]);
    }

    /** Create Page */
    public function create()
    {
        $brochure = [];
        return view('admin.brochure.create')->with(['brochure' => $brochure]);
    }

    /** Store Brochure */
    public function store(Request $request)
    {
        $rules = [
            'pdf' => 'required|mimes:pdf',
        ];

        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }  

        $brochure = new Brochure;
        $brochure->status = 'Active';

        if ($request->hasFile('pdf')) {
            $filename = rand().time().'.'.$request->pdf->extension();
            $request->pdf->move(public_path('uploads/brochure'), $filename);
            $brochure->pdf = 'uploads/brochure/'.$filename;
        }

        $brochure->save();
        return redirect('admin/brochure')->withSuccess('Brochure added successfully');
    }

    /** Edit Page */
    public function edit($id)
    {
        $brochure = Brochure::find($id);
        return view('admin.brochure.create',['brochure' => $brochure]);
    }

    /** Update Brochure */
    public function update(Request $request, $id)
    {
        $brochure = Brochure::find($id);

        // AJAX Status Update
        if ($request->ajax()) {
            $brochure->status = $brochure->status == 'Active' ? 'Inactive' : 'Active';
            $brochure->save();

            return response()->json([
                'success' => true,
                'newStatus' => $brochure->status
            ]);
        }

        $rules = [
            'pdf' => 'nullable|mimes:pdf',
        ];

        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        if ($request->hasFile('pdf')) {
            if (File::exists(public_path($brochure->pdf))) {
                File::delete(public_path($brochure->pdf));
            }
            $filename = rand().time().'.'.$request->pdf->extension();
            $request->pdf->move(public_path('uploads/brochure'), $filename);
            $brochure->pdf = 'uploads/brochure/'.$filename;
        } 

        $brochure->save();
        return redirect('admin/brochure')->withSuccess('Brochure updated successfully');
    }

    public function destroy(Request $request)
    {
        $brochure = Brochure::find($request->id);
        $brochure->deleted_at = now();
        $brochure->save();
        
        return redirect()->back()->withSuccess('Brochure removed successfully');
    }

    public function brochuredelete($id)
    {
        $brochure = Brochure::find($id);
        $brochure->deleted_at = now();
        $brochure->save();
        return 1;
    }
}
