<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Blog;
use File;
use Auth;
use DB;
 
class BlogController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }

    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $query = Blog::where('id','>','0');
        $count = $query->count();
        $result = $query->orderBy('id','DESC')->paginate(5);
        return view('admin.blog.index')->with(['result'=>$result]);
        
    }

   
    public function create()
    {
		$blog = [];
        return view('admin.blog.create')->with(['blog'=>$blog]);
    }

   
    public function store(Request $request)
    {
		
        $sValidationRules = [
            'name' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:5120',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }  
		$admin = New Blog;
		$admin->name = $request->name;
		$admin->description = $request->description;
		$admin->short_description = $request->short_description;
		$str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$admin->slug = rtrim($str, '-');
       
       
          if($request->hasFile('image')){
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/blog'), $image);
            $admin->image = 'uploads/blog/'.$image;
        } 
        
        $admin->save();
		
        return redirect('admin/blog')->withSuccess('Added successfully');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$blog = Blog::find($id);
		
        return view('admin.blog.create',['blog'=>$blog]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$blog = Blog::find($id);
	
        if ($request->ajax()) {
            if (!empty($request->currentStatus)) {
                $blog->status = $request->currentStatus == 'Active' ? 'Deactive' : 'Active';
            }
    
            $blog->save();
    
            return response()->json([
                'success' => true,
                'newStatus' => $blog->status
            ]);
        }
    
        $sValidationRules = [
             'name' => 'required',
             'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:5120',
       
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
     
        $str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$input['slug'] = rtrim($str, '-');
      
        
       
      if($request->hasFile('image')){
            if(file_exists(asset($blog->image))){
                unlink(asset($blog->image));
            }
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/blog'), $image);
            $input['image'] = 'uploads/blog/'.$image;
        } 
        $blog->update($input);
        return redirect('admin/blog')->withSuccess('Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = blog::find($request->id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Blog::where('id', '=', $request->id)->delete();
        return redirect(route('admin.blog'))->withSuccess('Deleted successfully');
    }
	
	 public function blogdelete($id)
    {
        $admin = Blog::find($id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Blog::where('id', '=', $id)->delete();
        return 1;
    }
}
