<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Aboutus;
use File;
use Auth;
use DB;
use Yajra\Datatables\Datatables;
use Illuminate\Http\Response;
class AboutusController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    private $data = array(
        'route' => 'admin.aboutus.',
        'title' => 'About Us',
        'menu' => 'aboutus',
        'submenu' => '',
    );
    public function __construct()
    {
      
    }

    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $records = Aboutus::select('aboutus.*');

            return Datatables::of($records)
                ->addIndexColumn()
                ->editColumn('image1', function ($record) {
                    return $record->image1
                        ? '<img src="' . asset($record->image1) . '" style="height:80px;">'
                        : '<img src="' . asset('assets/user/images/not-availbale.png') . '" style="height:80px;">';
                })
                /*->editColumn('image2', function ($record) {
                    return $record->image2
                        ? '<img src="' . asset($record->image2) . '" style="height:80px;">'
                        : '<img src="' . asset('assets/user/images/not-availbale.png') . '" style="height:80px;">';
                })
                ->editColumn('image3', function ($record) {
                    return $record->image3
                        ? '<img src="' . asset($record->image3) . '" style="height:80px;">'
                        : '<img src="' . asset('assets/user/images/not-availbale.png') . '" style="height:80px;">';
                })*/
                ->addColumn('action', function ($record) {
                    return '<a href="' . url('admin/aboutus/' . $record->id . '/edit') . '" 
                            class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="Edit">
                            <i class="fe fe-edit"></i></a>';
                })
                ->rawColumns(['action', 'image1', 'image2', 'image3'])
                ->make(true);
        }

        return view('admin.aboutus.index', $this->data);
    }

    public function show($id)
    {
		$aboutus = Aboutus::find($id);
        return view('admin.aboutus.show')->with(['aboutus'=>$aboutus]);
    }

   
    public function edit($id)
    {
		$aboutus = Aboutus::find($id);
		
        return view('admin.aboutus.create',['aboutus'=>$aboutus]);
    }

 
    public function update(Request $request, $id)
    {
        $aboutus = Aboutus::findOrFail($id);
    
        if ($request->ajax()) {
            if (!empty($request->currentStatus)) {
                $aboutus->status = ($request->currentStatus == 'Active') ? 'Deactive' : 'Active';
            }
            $aboutus->save();
            return response()->json(['success' => true, 'message' => 'Status updated successfully']);
        }
    
        $rules = [
            'name'        => 'required|string|max:255',
            'title'       => 'required|string|max:255',
            'description' => 'required|string',
            'image1'      => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
        ];
    
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) return redirect()->back()->withErrors($validator)->withInput();
    
        $aboutus->name = $request->name;
        $aboutus->title = $request->title;
        $aboutus->description = $request->description;
    
        foreach (['image1', 'image2', 'image3'] as $field) {
            if ($request->hasFile($field)) {
                if (!empty($aboutus->$field) && file_exists(public_path($aboutus->$field))) {
                    unlink(public_path($aboutus->$field));
                }
                $fileName = uniqid() . '.' . $request->file($field)->extension();
                $request->file($field)->move(public_path('uploads/aboutus'), $fileName);
                $aboutus->$field = 'uploads/aboutus/' . $fileName;
            }
        }
    
        $aboutus->save();
        return redirect('admin/aboutus')->withSuccess('About Us updated successfully');
    }
    
    
  
    public function destroy($id)
    {
        $admin = Aboutus::find($id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Aboutus::where('id', '=', $id)->delete();
        $response['success'] = true;
        $response['message'] = 'aboutus Deleted successfully';
        return response()->json($response);
    }
	
}
